/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.factory;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.impl.ProfileActionBeanPostProcessor;
import net.shibboleth.idp.profile.spring.factory.FlowRelativeResourceLoader;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.spring.config.IdentifiableBeanPostProcessor;
import net.shibboleth.shared.spring.context.FilesystemGenericApplicationContext;
import net.shibboleth.shared.spring.context.FilesystemGenericWebApplicationContext;
import net.shibboleth.shared.spring.custom.SchemaTypeAwareXMLBeanDefinitionReader;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestScope;
import org.springframework.webflow.engine.model.BeanImportModel;
import org.springframework.webflow.engine.model.registry.FlowModelHolder;
import org.springframework.webflow.scope.ConversationScope;
import org.springframework.webflow.scope.FlashScope;
import org.springframework.webflow.scope.FlowScope;
import org.springframework.webflow.scope.ViewScope;

public class FlowModelFlowBuilder
extends org.springframework.webflow.engine.builder.model.FlowModelFlowBuilder {
    public FlowModelFlowBuilder(FlowModelHolder flowModelHolder) {
        super(flowModelHolder);
    }

    protected GenericApplicationContext createFlowApplicationContext() {
        String[] contextResources = this.parseContextResources(this.getFlowModel().getBeanImports());
        return this.createFlowApplicationContext(contextResources);
    }

    @Nonnull
    private String[] parseContextResources(@Nullable List<BeanImportModel> beanImports) {
        if (beanImports != null && !beanImports.isEmpty()) {
            String[] resources = new String[beanImports.size()];
            List resultAsList = (List)((NonnullSupplier)beanImports.stream().map(BeanImportModel::getResource).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableList()))).get();
            String[] result = resultAsList.toArray(resources);
            assert (result != null);
            return result;
        }
        return new String[0];
    }

    private GenericApplicationContext createFlowApplicationContext(@Nonnull String[] resources) {
        FilesystemGenericApplicationContext flowContext;
        ApplicationContext parent = this.getContext().getApplicationContext();
        if (parent instanceof WebApplicationContext) {
            FilesystemGenericWebApplicationContext webContext = new FilesystemGenericWebApplicationContext();
            webContext.setServletContext(((WebApplicationContext)parent).getServletContext());
            flowContext = webContext;
        } else {
            flowContext = new FilesystemGenericApplicationContext();
        }
        flowContext.setDisplayName("Flow ApplicationContext [" + this.getContext().getFlowId() + "]");
        flowContext.setParent(parent);
        flowContext.getBeanFactory().registerScope("request", (Scope)new RequestScope());
        flowContext.getBeanFactory().registerScope("flash", (Scope)new FlashScope());
        flowContext.getBeanFactory().registerScope("view", (Scope)new ViewScope());
        flowContext.getBeanFactory().registerScope("flow", (Scope)new FlowScope());
        flowContext.getBeanFactory().registerScope("conversation", (Scope)new ConversationScope());
        ClassLoader classLoaderToUse = flowContext.getClassLoader();
        flowContext.setClassLoader(classLoaderToUse);
        Resource flowResource = this.getFlowModelHolder().getFlowModelResource();
        flowContext.setResourceLoader((ResourceLoader)new FlowRelativeResourceLoader(flowResource));
        flowContext.getEnvironment().setPlaceholderPrefix("%{");
        flowContext.getEnvironment().setPlaceholderSuffix("}");
        AnnotationConfigUtils.registerAnnotationConfigProcessors((BeanDefinitionRegistry)flowContext);
        PropertySourcesPlaceholderConfigurer propertyConfigurer = new PropertySourcesPlaceholderConfigurer();
        propertyConfigurer.setPlaceholderPrefix("%{");
        propertyConfigurer.setPlaceholderSuffix("}");
        propertyConfigurer.setEnvironment((Environment)flowContext.getEnvironment());
        flowContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)propertyConfigurer);
        flowContext.getBeanFactory().addBeanPostProcessor((BeanPostProcessor)new IdentifiableBeanPostProcessor());
        flowContext.getBeanFactory().addBeanPostProcessor((BeanPostProcessor)new ProfileActionBeanPostProcessor());
        new SchemaTypeAwareXMLBeanDefinitionReader((BeanDefinitionRegistry)flowContext).loadBeanDefinitions(resources);
        this.registerFlowBeans((ConfigurableBeanFactory)flowContext.getBeanFactory());
        flowContext.refresh();
        return flowContext;
    }
}

