/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.factory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.ContextResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.VfsResource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.StringUtils;
import org.springframework.webflow.config.FlowDefinitionResource;
import org.springframework.webflow.core.collection.AttributeMap;

public class FlowDefinitionResourceFactory {
    @Nonnull
    @NotEmpty
    private static final String CLASSPATH_SCHEME = "classpath:";
    @Nonnull
    @NotEmpty
    private static final String CLASSPATH_STAR_SCHEME = "classpath*:";
    @Nonnull
    @NotEmpty
    private static final String FILESYSTEM_SCHEME = "file:";
    @Nonnull
    @NotEmpty
    private static final String SLASH = "/";
    @Nonnull
    private final ResourceLoader resourceLoader;

    public FlowDefinitionResourceFactory(@Nonnull ResourceLoader loader) {
        this.resourceLoader = (ResourceLoader)Constraint.isNotNull((Object)loader, (String)"The resource loader cannot be null");
    }

    @Nonnull
    public FlowDefinitionResource createResource(@Nullable String basePath, @Nonnull @NotEmpty String path, @Nonnull AttributeMap<Object> attributes, @Nonnull @NotEmpty String flowId) {
        Resource resource;
        Constraint.isNotEmpty((String)path, (String)"Flow path cannot be null or empty");
        Constraint.isNotEmpty((String)flowId, (String)"Flow ID cannot be null or empty");
        if (basePath == null || this.isAbsolute(path)) {
            resource = this.resourceLoader.getResource(path);
        } else {
            resource = this.resourceLoader.getResource(path);
            if (!resource.exists()) {
                try {
                    Object localBasePath = basePath;
                    if (!((String)localBasePath).endsWith(SLASH)) {
                        localBasePath = basePath + SLASH;
                    }
                    resource = this.resourceLoader.getResource((String)localBasePath).createRelative(path);
                }
                catch (IOException e) {
                    throw new IllegalStateException("The base path cannot be resolved from '" + basePath + "'", e);
                }
            }
        }
        return new FlowDefinitionResource(flowId, resource, attributes);
    }

    @Nonnull
    public Collection<FlowDefinitionResource> createResources(@Nonnull @NotEmpty String basePath, @Nonnull @NotEmpty String pattern, @Nonnull AttributeMap<Object> attributes) throws IOException {
        Constraint.isNotEmpty((String)basePath, (String)"Base location cannot be null or empty");
        Constraint.isNotEmpty((String)pattern, (String)"Flow pattern cannot be null or empty");
        if (!(this.resourceLoader instanceof ResourcePatternResolver)) {
            throw new IllegalStateException("Cannot create flow definition resources from patterns without a ResourcePatternResolver");
        }
        ResourcePatternResolver resolver = (ResourcePatternResolver)this.resourceLoader;
        Resource[] resources = this.isAbsolute(pattern) ? resolver.getResources(pattern) : (basePath.endsWith(SLASH) || pattern.startsWith(SLASH) ? resolver.getResources(basePath + pattern) : resolver.getResources(basePath + SLASH + pattern));
        if (resources.length == 0) {
            return CollectionSupport.emptyList();
        }
        ArrayList<FlowDefinitionResource> flowResources = new ArrayList<FlowDefinitionResource>(resources.length);
        for (Resource resource : resources) {
            assert (resource != null);
            flowResources.add(new FlowDefinitionResource(this.getFlowId(basePath, resource), resource, attributes));
        }
        return flowResources;
    }

    protected String getFlowId(@Nonnull @NotEmpty String basePath, @Nonnull Resource flowResource) throws IOException {
        String filePath;
        String localBasePath = this.removeScheme(basePath);
        if (flowResource instanceof ContextResource) {
            filePath = ((ContextResource)flowResource).getPathWithinContext();
        } else if (flowResource instanceof ClassPathResource) {
            filePath = ((ClassPathResource)flowResource).getPath();
        } else if (flowResource instanceof FileSystemResource) {
            filePath = this.truncateFilePath(((FileSystemResource)flowResource).getPath(), localBasePath);
        } else if (flowResource instanceof UrlResource || flowResource instanceof VfsResource) {
            String path = flowResource.getURL().getPath();
            assert (path != null);
            filePath = this.truncateFilePath(path, localBasePath);
        } else {
            String fname = flowResource.getFilename();
            if (fname != null) {
                return StringUtils.stripFilenameExtension((String)fname);
            }
            throw new IOException("Unable to obtain filename from Resource of type " + flowResource.getClass().getName());
        }
        int beginIndex = 0;
        int endIndex = filePath.length();
        if (filePath.startsWith(localBasePath)) {
            beginIndex = localBasePath.length();
        } else if (filePath.startsWith(SLASH + localBasePath)) {
            beginIndex = localBasePath.length() + 1;
        }
        if (filePath.startsWith(SLASH, beginIndex)) {
            ++beginIndex;
        }
        if (filePath.lastIndexOf(SLASH) < beginIndex) {
            String fname = flowResource.getFilename();
            if (fname != null) {
                return StringUtils.stripFilenameExtension((String)fname);
            }
            throw new IOException("Unable to obtain filename from Resource of type " + flowResource.getClass().getName());
        }
        endIndex = filePath.lastIndexOf(SLASH);
        return filePath.substring(beginIndex, endIndex);
    }

    @Nonnull
    @NotEmpty
    private String truncateFilePath(@Nonnull @NotEmpty String filePath, @Nonnull @NotEmpty String basePath) {
        int basePathIndex = filePath.lastIndexOf(basePath);
        if (basePathIndex != -1) {
            String result = filePath.substring(basePathIndex);
            assert (result != null);
            return result;
        }
        return filePath;
    }

    private boolean isAbsolute(@Nonnull @NotEmpty String path) {
        if (path.startsWith(CLASSPATH_SCHEME)) {
            return true;
        }
        if (path.startsWith(CLASSPATH_STAR_SCHEME)) {
            return true;
        }
        return path.startsWith(FILESYSTEM_SCHEME);
    }

    @Nonnull
    private String removeScheme(@Nonnull @NotEmpty String path) {
        String result = path.startsWith(CLASSPATH_SCHEME) ? path.substring(CLASSPATH_SCHEME.length()) : (path.startsWith(FILESYSTEM_SCHEME) ? path.substring(FILESYSTEM_SCHEME.length()) : (path.startsWith(CLASSPATH_STAR_SCHEME) ? path.substring(CLASSPATH_STAR_SCHEME.length()) : path));
        assert (result != null);
        return result;
    }
}

