/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.servlet.impl;

import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.HttpCookie;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.servlet.AbstractConditionalFilter;
import net.shibboleth.shared.spring.servlet.ChainableFilter;
import org.slf4j.Logger;

public class SameSiteCookieHeaderFilter
extends AbstractConditionalFilter
implements ChainableFilter {
    @Nonnull
    @NotEmpty
    private static final String SAMESITE_ATTRIBITE_NAME = "SameSite";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SameSiteCookieHeaderFilter.class);
    private boolean disableBasedOnServletAPI = true;
    @Nullable
    private SameSiteValue defaultValue;
    @Nonnull
    private Map<String, SameSiteValue> sameSiteCookies = CollectionSupport.emptyMap();

    public void setDisableBasedOnServletAPI(boolean flag) {
        this.disableBasedOnServletAPI = flag;
    }

    public void setDefaultValue(@Nullable SameSiteValue value) {
        this.defaultValue = value;
    }

    public void setSameSiteCookies(@Nullable Map<SameSiteValue, List<String>> map) {
        if (map != null) {
            this.sameSiteCookies = new HashMap<String, SameSiteValue>(4);
            for (Map.Entry<SameSiteValue, List<String>> entry : map.entrySet()) {
                for (String cookieName : entry.getValue()) {
                    if (this.sameSiteCookies.get(cookieName) != null) {
                        this.log.error("Duplicate cookie name '{}' found in SameSite cookie map, please check configuration.", (Object)cookieName);
                        throw new IllegalArgumentException("Duplicate cookie name found in SameSite cookie map");
                    }
                    String trimmedName = StringSupport.trimOrNull((String)cookieName);
                    if (trimmedName == null) continue;
                    this.sameSiteCookies.put(cookieName, entry.getKey());
                }
            }
        } else {
            this.sameSiteCookies = CollectionSupport.emptyMap();
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    @Override
    public int getOrder() {
        return ChainableFilter.FilterOrder.EARLIEST.getValue();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.disableBasedOnServletAPI && request.getServletContext().getMajorVersion() >= 6) {
            chain.doFilter(request, response);
            return;
        }
        super.doFilter(request, response, chain);
    }

    protected void runFilter(@Nonnull ServletRequest request, @Nonnull ServletResponse response, @Nonnull FilterChain chain) throws IOException, ServletException {
        if (!(response instanceof HttpServletResponse)) {
            throw new ServletException("Response is not an instance of HttpServletResponse");
        }
        chain.doFilter(request, (ServletResponse)new SameSiteResponseProxy((HttpServletResponse)response));
    }

    public static enum SameSiteValue {
        Strict("Strict"),
        Lax("Lax"),
        None("None"),
        Null("Null");

        @Nonnull
        @NotEmpty
        private String value;

        private SameSiteValue(String attrValue) {
            this.value = Constraint.isNotEmpty((String)attrValue, (String)"the same-site attribute value can not be empty");
        }

        @Nonnull
        public String getValue() {
            return this.value;
        }
    }

    private class SameSiteResponseProxy
    extends HttpServletResponseWrapper {
        @Nonnull
        private final HttpServletResponse response;

        public SameSiteResponseProxy(HttpServletResponse resp) {
            super(resp);
            this.response = resp;
        }

        public void sendError(int sc) throws IOException {
            this.appendSameSite();
            super.sendError(sc);
        }

        public PrintWriter getWriter() throws IOException {
            this.appendSameSite();
            return super.getWriter();
        }

        public void sendError(int sc, String msg) throws IOException {
            this.appendSameSite();
            super.sendError(sc, msg);
        }

        public void sendRedirect(String location) throws IOException {
            this.appendSameSite();
            super.sendRedirect(location);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            this.appendSameSite();
            return super.getOutputStream();
        }

        private void appendSameSite() {
            Collection cookieheaders = this.response.getHeaders("Set-Cookie");
            boolean firstHeader = true;
            for (String cookieHeader : cookieheaders) {
                if (StringSupport.trimOrNull((String)cookieHeader) == null) continue;
                assert (cookieHeader != null);
                List<HttpCookie> parsedCookies = null;
                try {
                    parsedCookies = HttpCookie.parse(cookieHeader);
                }
                catch (IllegalArgumentException e) {
                    SameSiteCookieHeaderFilter.this.log.trace("Cookie header '{}' violates the cookie specification and will be ignored", (Object)cookieHeader);
                }
                if (parsedCookies == null || parsedCookies.size() != 1) continue;
                SameSiteValue sameSiteValue = SameSiteCookieHeaderFilter.this.sameSiteCookies.get(parsedCookies.get(0).getName());
                if (sameSiteValue != null) {
                    if (sameSiteValue != SameSiteValue.Null) {
                        this.appendSameSiteAttribute(cookieHeader, sameSiteValue.getValue(), firstHeader);
                    } else if (firstHeader) {
                        this.response.setHeader("Set-Cookie", cookieHeader);
                    } else {
                        this.response.addHeader("Set-Cookie", cookieHeader);
                    }
                } else if (SameSiteCookieHeaderFilter.this.defaultValue != null && SameSiteCookieHeaderFilter.this.defaultValue != SameSiteValue.Null) {
                    this.appendSameSiteAttribute(cookieHeader, SameSiteCookieHeaderFilter.this.defaultValue.getValue(), firstHeader);
                } else if (firstHeader) {
                    this.response.setHeader("Set-Cookie", cookieHeader);
                } else {
                    this.response.addHeader("Set-Cookie", cookieHeader);
                }
                firstHeader = false;
            }
        }

        private void appendSameSiteAttribute(@Nonnull @NotEmpty String cookieHeader, @Nonnull @NotEmpty String sameSiteValue, boolean first) {
            String sameSiteSetCookieValue = cookieHeader;
            if (!cookieHeader.contains(SameSiteCookieHeaderFilter.SAMESITE_ATTRIBITE_NAME)) {
                sameSiteSetCookieValue = String.format("%s; %s", cookieHeader, "SameSite=" + sameSiteValue);
            }
            if (first) {
                this.response.setHeader("Set-Cookie", sameSiteSetCookieValue);
            } else {
                this.response.addHeader("Set-Cookie", sameSiteSetCookieValue);
            }
        }
    }
}

