/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.context;

import javax.annotation.Nonnull;
import net.shibboleth.shared.spring.resource.ConditionalResourceResolver;
import net.shibboleth.shared.spring.util.AnnotationParameterNameDiscoverer;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class FilesystemGenericApplicationContext
extends GenericApplicationContext {
    public FilesystemGenericApplicationContext() {
        this.getDefaultListableBeanFactory().setParameterNameDiscoverer((ParameterNameDiscoverer)new AnnotationParameterNameDiscoverer());
        this.addProtocolResolver(new ConditionalResourceResolver());
    }

    public FilesystemGenericApplicationContext(DefaultListableBeanFactory beanFactory) {
        super(beanFactory);
        beanFactory.setParameterNameDiscoverer((ParameterNameDiscoverer)new AnnotationParameterNameDiscoverer());
        this.addProtocolResolver(new ConditionalResourceResolver());
    }

    public FilesystemGenericApplicationContext(ApplicationContext parent) {
        super(parent);
        this.getDefaultListableBeanFactory().setParameterNameDiscoverer((ParameterNameDiscoverer)new AnnotationParameterNameDiscoverer());
        this.addProtocolResolver(new ConditionalResourceResolver());
    }

    public FilesystemGenericApplicationContext(DefaultListableBeanFactory beanFactory, ApplicationContext parent) {
        super(beanFactory, parent);
        beanFactory.setParameterNameDiscoverer((ParameterNameDiscoverer)new AnnotationParameterNameDiscoverer());
        this.addProtocolResolver(new ConditionalResourceResolver());
    }

    @Nonnull
    protected Resource getResourceByPath(@Nonnull String path) {
        try {
            FileSystemResource r = new FileSystemResource(path);
            if (r.exists()) {
                return r;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.getResourceByPath(path);
    }
}

