/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.x509.dn;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.X500Name;
import org.cryptacular.CryptUtil;
import org.cryptacular.x509.dn.Attribute;
import org.cryptacular.x509.dn.Attributes;
import org.cryptacular.x509.dn.RDN;
import org.cryptacular.x509.dn.RDNSequence;

public class NameReader {
    private final X509Certificate certificate;

    public NameReader(X509Certificate cert) {
        this.certificate = CryptUtil.assertNotNullArg(cert, "Certificate cannot be null.");
    }

    public RDNSequence readSubject() {
        return NameReader.readX500Principal(this.certificate.getSubjectX500Principal());
    }

    public RDNSequence readIssuer() {
        return NameReader.readX500Principal(this.certificate.getIssuerX500Principal());
    }

    public static RDNSequence readX500Principal(X500Principal principal) {
        CryptUtil.assertNotNullArg(principal, "Principal cannot be null.");
        return NameReader.readX500Name(X500Name.getInstance((Object)principal.getEncoded()));
    }

    public static RDNSequence readX500Name(X500Name name) {
        CryptUtil.assertNotNullArg(name, "Name cannot be null.");
        ArrayList<RDN> rdns = new ArrayList<RDN>();
        for (org.bouncycastle.asn1.x500.RDN rdn : name.getRDNs()) {
            ArrayList<Attribute> attrs = new ArrayList<Attribute>();
            for (AttributeTypeAndValue tv : rdn.getTypesAndValues()) {
                attrs.add(new Attribute(tv.getType().getId(), tv.getValue().toString()));
            }
            rdns.add(new RDN(new Attributes(attrs)));
        }
        return new RDNSequence(rdns);
    }
}

