/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.codec;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import org.cryptacular.CryptUtil;
import org.cryptacular.EncodingException;
import org.cryptacular.codec.Decoder;

public abstract class AbstractBaseNDecoder
implements Decoder {
    private final char[] block = new char[this.getBlockLength() / this.getBitsPerChar()];
    private final byte[] decodingTable;
    private final boolean paddedInput;
    private int blockPos;

    public AbstractBaseNDecoder(byte[] decodingTable) {
        this(decodingTable, true);
    }

    public AbstractBaseNDecoder(byte[] decodingTable, boolean paddedInput) {
        this.decodingTable = CryptUtil.assertNotNullArg(decodingTable, "Decoding table cannot be null");
        this.paddedInput = paddedInput;
    }

    public boolean isPaddedInput() {
        return this.paddedInput;
    }

    @Override
    public void decode(CharBuffer input, ByteBuffer output) throws EncodingException {
        CryptUtil.assertNotNullArg(input, "Input cannot be null");
        CryptUtil.assertNotNullArg(output, "Output cannot be null");
        while (input.hasRemaining()) {
            char current = input.get();
            if (Character.isWhitespace(current) || current == '=') continue;
            this.block[this.blockPos++] = current;
            if (this.blockPos != this.block.length) continue;
            this.writeOutput(output, this.block.length);
        }
    }

    @Override
    public void finalize(ByteBuffer output) throws EncodingException {
        CryptUtil.assertNotNullArg(output, "Output cannot be null");
        if (this.blockPos > 0) {
            try {
                this.writeOutput(output, this.blockPos);
            }
            catch (BufferOverflowException e) {
                throw new EncodingException("Buffer overflow", e);
            }
        }
    }

    @Override
    public int outputSize(int inputSize) {
        int size = this.paddedInput ? inputSize : inputSize + this.getBlockLength() / 8 - 1;
        return size * this.getBitsPerChar() / 8;
    }

    protected abstract int getBlockLength();

    protected abstract int getBitsPerChar();

    protected static byte[] decodingTable(String alphabet, int n) {
        CryptUtil.assertNotNullArg(alphabet, "Alphabet cannot be null");
        if (alphabet.length() != n) {
            throw new IllegalArgumentException("Alphabet must be exactly " + n + " characters long");
        }
        byte[] decodingTable = new byte[128];
        for (int i = 0; i < n; ++i) {
            decodingTable[alphabet.charAt((int)i)] = (byte)i;
        }
        return decodingTable;
    }

    private void writeOutput(ByteBuffer output, int len) {
        long value = 0L;
        int shift = this.getBlockLength();
        for (int i = 0; i < len; ++i) {
            long b = this.decodingTable[this.block[i] & 0x7F];
            if (b < 0L) {
                throw new EncodingException("Invalid character " + this.block[i]);
            }
            value |= b << (shift -= this.getBitsPerChar());
        }
        int stop = shift + this.getBitsPerChar() - 1;
        int offset = this.getBlockLength();
        while (offset > stop) {
            output.put((byte)((value & 255L << (offset -= 8)) >> offset));
        }
        this.blockPos = 0;
    }
}

