/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.bean;

import java.io.IOException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.cryptacular.CryptUtil;
import org.cryptacular.StreamException;
import org.cryptacular.bean.FactoryBean;
import org.cryptacular.io.Resource;
import org.cryptacular.util.StreamUtil;

public class ResourceBasedSecretKeyFactoryBean
implements FactoryBean<SecretKey> {
    private final String algorithm;
    private final Resource resource;

    public ResourceBasedSecretKeyFactoryBean(Resource resource, String algorithm) {
        this.resource = CryptUtil.assertNotNullArg(resource, "Resource cannot be null");
        this.algorithm = CryptUtil.assertNotNullArg(algorithm, "Algorithm cannot be null");
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public Resource getResource() {
        return this.resource;
    }

    @Override
    public SecretKey newInstance() throws StreamException {
        try {
            return new SecretKeySpec(StreamUtil.readAll(this.resource.getInputStream()), this.algorithm);
        }
        catch (IOException e) {
            throw new StreamException(e);
        }
    }
}

