/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.service;

import java.security.Principal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;

public class Service
implements Principal {
    @Nonnull
    @NotEmpty
    private final String serviceURL;
    @Nullable
    private final String serviceGroup;
    private final boolean authorizedToProxy;
    private final boolean singleLogoutParticipant;
    @Nullable
    private transient EntityDescriptor entityDescriptor;
    @Nullable
    private transient RoleDescriptor roleDescriptor;

    public Service(@Nonnull @NotEmpty String url, @Nullable @NotEmpty String group, boolean proxy) {
        this(url, group, proxy, false);
    }

    public Service(@Nonnull @NotEmpty String url, @Nullable @NotEmpty String group, boolean proxy, boolean wantsSLO) {
        this.serviceURL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)url), (String)"Service URL cannot be null or empty");
        this.serviceGroup = StringSupport.trimOrNull((String)group);
        this.authorizedToProxy = proxy;
        this.singleLogoutParticipant = wantsSLO;
    }

    @Override
    public String getName() {
        return this.serviceURL;
    }

    @Nullable
    public String getGroup() {
        return this.serviceGroup;
    }

    public boolean isAuthorizedToProxy() {
        return this.authorizedToProxy;
    }

    public boolean isSingleLogoutParticipant() {
        return this.singleLogoutParticipant;
    }

    @Nullable
    public EntityDescriptor getEntityDescriptor() {
        return this.entityDescriptor;
    }

    public void setEntityDescriptor(@Nullable EntityDescriptor ed) {
        this.entityDescriptor = ed;
    }

    @Nullable
    public RoleDescriptor getRoleDescriptor() {
        return this.roleDescriptor;
    }

    public void setRoleDescriptor(@Nullable RoleDescriptor role) {
        this.roleDescriptor = role;
    }

    @Override
    public String toString() {
        return this.serviceURL;
    }
}

