/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session;

import com.google.common.base.MoreObjects;
import java.time.Instant;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;

@ThreadSafe
public class BasicSPSession
implements SPSession {
    @Nonnull
    @NotEmpty
    private final String serviceId;
    @Nonnull
    private final Instant creationInstant;
    @Nonnull
    private final Instant expirationInstant;

    public BasicSPSession(@Nonnull @NotEmpty String id, @Nonnull Instant creation, @Nonnull Instant expiration) {
        this.serviceId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)id), (String)"Service ID cannot be null nor empty");
        this.creationInstant = (Instant)Constraint.isNotNull((Object)creation, (String)"Creation instant cannot be null");
        this.expirationInstant = (Instant)Constraint.isNotNull((Object)expiration, (String)"Expiration instant cannot be null");
    }

    @Nonnull
    @NotEmpty
    public String getId() {
        return this.serviceId;
    }

    @Override
    @Nonnull
    public Instant getCreationInstant() {
        return this.creationInstant;
    }

    @Override
    @Nonnull
    public Instant getExpirationInstant() {
        return this.expirationInstant;
    }

    @Override
    @Nullable
    public String getSPSessionKey() {
        return null;
    }

    @Override
    @Nullable
    @NotEmpty
    public String getProtocol() {
        return null;
    }

    @Override
    public boolean supportsLogoutPropagation() {
        return false;
    }

    public int hashCode() {
        return this.serviceId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof BasicSPSession) {
            return Objects.equals(this.serviceId, ((BasicSPSession)obj).getId());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.serviceId).add("creationInstant", (Object)this.creationInstant).add("expirationInstant", (Object)this.expirationInstant).toString();
    }
}

