/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc.saml.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.resolver.dc.saml.impl.BasicResponseMappingStrategy;
import net.shibboleth.idp.attribute.resolver.dc.saml.impl.ExecutableQueryBuilder;
import net.shibboleth.idp.attribute.resolver.dc.saml.impl.SAMLDataConnector;
import net.shibboleth.idp.attribute.resolver.dc.saml.plugin.impl.CriteriaDecryptionConfigurationLookup;
import net.shibboleth.idp.attribute.resolver.dc.saml.util.impl.AssertionValidationProcessor;
import net.shibboleth.idp.attribute.resolver.dc.saml.util.impl.DecryptionProcessor;
import net.shibboleth.idp.attribute.resolver.dc.saml.util.impl.SubjectMatchProcessor;
import net.shibboleth.idp.attribute.resolver.spring.dc.AbstractDataConnectorParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.impl.CacheConfigParser;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.xml.ElementSupport;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.saml2.core.Attribute;
import org.slf4j.Logger;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractSAMLDataConnectorParser
extends AbstractDataConnectorParser {
    @Nonnull
    private static final Map<String, CustomPropertyDef> CUSTOM_PROPERTY_DEFS = new HashMap<String, CustomPropertyDef>();
    @Nonnull
    private final Map<String, CustomPropertyValue> resolvedCustomProperties = new HashMap<String, CustomPropertyValue>();
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractSAMLDataConnectorParser.class);

    protected AbstractSAMLDataConnectorParser() {
        this.resolveAndStoreCustomProperties(CUSTOM_PROPERTY_DEFS);
    }

    private void parseCommonDataConnector(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        String resultCacheBeanID = CacheConfigParser.getBeanResultCacheID(config);
        if (null != resultCacheBeanID) {
            builder.addPropertyReference("resultsCache", resultCacheBeanID);
        } else {
            CacheConfigParser parser = new CacheConfigParser(config);
            builder.addPropertyValue("resultsCache", (Object)parser.createCache());
        }
    }

    @Nonnull
    protected BeanDefinition parseSAMLDataConnector(@Nonnull Element config, @Nonnull ParserContext parserContext) {
        BeanDefinitionBuilder samlBuilder = BeanDefinitionBuilder.genericBeanDefinition(SAMLDataConnector.class);
        String ownerID = StringSupport.trimOrNull((String)config.getAttributeNS(null, "id"));
        samlBuilder.addPropertyValue("id", (Object)(ownerID + ".QueryConnector"));
        this.parseCommonDataConnector(config, parserContext, samlBuilder);
        samlBuilder.addPropertyValue("executableSearchBuilder", (Object)this.parseQueryBuilder(config, parserContext));
        samlBuilder.addPropertyValue("mappingStrategy", (Object)this.parseMappingStrategy(config, parserContext));
        this.addCustomProperties(samlBuilder, "SOAPClient");
        samlBuilder.addPropertyValue("decryptionProcessor", (Object)this.parseDecryptionProcessor(config, parserContext));
        samlBuilder.addPropertyValue("assertionValidationProcessor", (Object)this.parseAssertionValidationProcessor(config, parserContext));
        samlBuilder.addPropertyValue("subjectMatchProcessor", (Object)this.parseSubjectMatchProcessor(config, parserContext));
        if (config.hasAttributeNS(null, "subjectMatch")) {
            samlBuilder.addPropertyValue("subjectMatch", (Object)StringSupport.trimOrNull((String)config.getAttributeNS(null, "subjectMatch")));
        } else {
            samlBuilder.addPropertyValue("subjectMatch", (Object)false);
        }
        samlBuilder.setInitMethodName("initialize");
        samlBuilder.setDestroyMethodName("destroy");
        return samlBuilder.getBeanDefinition();
    }

    @Nonnull
    protected BeanDefinition parseMappingStrategy(@Nonnull Element config, @Nonnull ParserContext parserContext) {
        BeanDefinitionBuilder mappingBuilder = BeanDefinitionBuilder.genericBeanDefinition(BasicResponseMappingStrategy.class);
        if (config.hasAttributeNS(null, "filterAttributes")) {
            mappingBuilder.addPropertyValue("filterAttributes", (Object)StringSupport.trimOrNull((String)config.getAttributeNS(null, "filterAttributes")));
        } else {
            mappingBuilder.addPropertyValue("filterAttributes", (Object)"true");
        }
        this.addCustomProperties(mappingBuilder, "transcoderRegistry", "metadataResolver", "roleDescriptorResolver", "attributeFilterService");
        return mappingBuilder.getBeanDefinition();
    }

    @Nonnull
    protected BeanDefinition parseQueryBuilder(@Nonnull Element config, @Nonnull ParserContext parserContext) {
        List attributeElems;
        BeanDefinitionBuilder queryBuilder = BeanDefinitionBuilder.genericBeanDefinition(ExecutableQueryBuilder.class);
        this.addCustomProperties(queryBuilder, "authorityEndpointResolver", "roleDescriptorResolver", "identifierGenerationStrategy", "SOAPPipelineName", "SOAPClientSecurityConfigurationProfileId");
        queryBuilder.addPropertyValue("authorityEntityIDStrategy", (Object)this.getAuthorityEntityIDStrategy(config, parserContext));
        queryBuilder.addPropertyValue("selfEntityIDStrategy", (Object)this.getSelfEntityIDStrategy(config, parserContext));
        queryBuilder.addPropertyValue("subjectStrategy", (Object)this.getSubjectStrategy(config, parserContext));
        Element requestedAttributesParent = ElementSupport.getFirstChildElement((Node)config, (QName)new QName("urn:mace:shibboleth:2.0:resolver", "RequestedAttributes"));
        if (requestedAttributesParent != null && !(attributeElems = ElementSupport.getChildElements((Node)requestedAttributesParent, (QName)Attribute.DEFAULT_ELEMENT_NAME)).isEmpty()) {
            Unmarshaller unmarshaller = XMLObjectSupport.getUnmarshaller((QName)Attribute.DEFAULT_ELEMENT_NAME);
            if (unmarshaller == null) {
                throw new BeanCreationException("Could not obtain unmarshaller for SAML 2 Attribute type");
            }
            assert (unmarshaller != null);
            ArrayList<Attribute> requestedAttributes = new ArrayList<Attribute>();
            for (Element attributeElem : attributeElems) {
                assert (attributeElem != null);
                try {
                    Attribute attribute = (Attribute)unmarshaller.unmarshall(attributeElem);
                    requestedAttributes.add(attribute);
                }
                catch (UnmarshallingException e) {
                    throw new BeanCreationException("Error unmarshalling configured requested SAML 2 Attribute", (Throwable)e);
                }
            }
            queryBuilder.addPropertyValue("requestedAttributes", requestedAttributes);
        }
        queryBuilder.setInitMethodName("initialize");
        queryBuilder.setDestroyMethodName("destroy");
        return queryBuilder.getBeanDefinition();
    }

    @Nonnull
    protected BeanDefinition parseDecryptionProcessor(@Nonnull Element config, @Nonnull ParserContext parserContext) {
        BeanDefinitionBuilder configLookupBuilder = BeanDefinitionBuilder.genericBeanDefinition(CriteriaDecryptionConfigurationLookup.class);
        this.addCustomProperties(configLookupBuilder, "decryptionConfigurationResolver", "securityConfigurationProfileId");
        configLookupBuilder.setInitMethodName("initialize");
        configLookupBuilder.setDestroyMethodName("destroy");
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(DecryptionProcessor.class);
        builder.addPropertyValue("decryptionConfigurationLookupStrategy", (Object)configLookupBuilder.getBeanDefinition());
        this.addCustomProperties(builder, "decryptionParametersResolver");
        builder.setInitMethodName("initialize");
        builder.setDestroyMethodName("destroy");
        return builder.getBeanDefinition();
    }

    @Nonnull
    protected BeanDefinition parseAssertionValidationProcessor(@Nonnull Element config, @Nonnull ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(AssertionValidationProcessor.class);
        this.addCustomProperties(builder, "assertionValidationContextBuilder", "assertionValidator");
        builder.setInitMethodName("initialize");
        builder.setDestroyMethodName("destroy");
        return builder.getBeanDefinition();
    }

    @Nonnull
    protected BeanDefinition parseSubjectMatchProcessor(@Nonnull Element config, @Nonnull ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(SubjectMatchProcessor.class);
        return builder.getBeanDefinition();
    }

    @Nullable
    protected CustomPropertyValue getResolvedCustomProperty(@Nonnull String propName) {
        return this.resolvedCustomProperties.get(propName);
    }

    protected void addCustomProperties(@Nonnull BeanDefinitionBuilder builder, String ... propNames) {
        for (String propName : propNames) {
            assert (propName != null);
            CustomPropertyValue propValue = this.getResolvedCustomProperty(propName);
            if (propValue == null) continue;
            if (propValue.isReference()) {
                builder.addPropertyReference(propName, propValue.getValue());
                continue;
            }
            builder.addPropertyValue(propName, (Object)propValue.getValue());
        }
    }

    protected void resolveAndStoreCustomProperties(@Nonnull Map<String, CustomPropertyDef> customPropertyDefs) {
        for (String beanProp : customPropertyDefs.keySet()) {
            CustomPropertyDef def = customPropertyDefs.get(beanProp);
            String propName = String.format("%s.%s.%s", def.getPrefix().getName(), def.getName(), def.getType());
            assert (propName != null);
            String propValue = AbstractSAMLDataConnectorParser.getCustomProperty((String)propName, (String)def.getDefault());
            if (propValue != null) {
                this.log.debug("For bean property '{}', resolved custom property value: {}", (Object)propName, (Object)propValue);
                this.resolvedCustomProperties.put(beanProp, new CustomPropertyValue(propValue, def.isReference()));
                continue;
            }
            if (!def.isRequired()) continue;
            throw new BeanCreationException("Required custom property not found: " + propName);
        }
    }

    @Nonnull
    protected abstract BeanDefinition getAuthorityEntityIDStrategy(@Nonnull Element var1, @Nonnull ParserContext var2);

    @Nonnull
    protected abstract BeanDefinition getSelfEntityIDStrategy(@Nonnull Element var1, @Nonnull ParserContext var2);

    @Nonnull
    protected abstract BeanDefinition getSubjectStrategy(@Nonnull Element var1, @Nonnull ParserContext var2);

    static {
        CUSTOM_PROPERTY_DEFS.put("authorityEndpointResolver", new CustomPropertyDef(AbstractSAMLDataConnectorParser.class, "EndpointResolver", "bean", true, true));
        CUSTOM_PROPERTY_DEFS.put("roleDescriptorResolver", new CustomPropertyDef(AbstractSAMLDataConnectorParser.class, "RoleDescriptorResolver", "bean", true, true));
        CUSTOM_PROPERTY_DEFS.put("identifierGenerationStrategy", new CustomPropertyDef(AbstractSAMLDataConnectorParser.class, "IdentifierGenerationStrategy", "bean", true, true));
        CUSTOM_PROPERTY_DEFS.put("SOAPClient", new CustomPropertyDef(AbstractSAMLDataConnectorParser.class, "SOAPClient", "bean", true, true));
        CUSTOM_PROPERTY_DEFS.put("SOAPPipelineName", new CustomPropertyDef(AbstractSAMLDataConnectorParser.class, "SOAPPipelineName", "value", false, true));
        CUSTOM_PROPERTY_DEFS.put("SOAPClientSecurityConfigurationProfileId", new CustomPropertyDef(AbstractSAMLDataConnectorParser.class, "SOAPClientSecurityConfigurationProfileId", "value", false, true));
        CUSTOM_PROPERTY_DEFS.put("decryptionConfigurationResolver", new CustomPropertyDef(AbstractSAMLDataConnectorParser.class, "DecryptionConfigurationResolver", "bean", true, true));
        CUSTOM_PROPERTY_DEFS.put("decryptionParametersResolver", new CustomPropertyDef(AbstractSAMLDataConnectorParser.class, "DecryptionParametersResolver", "bean", true, true));
        CUSTOM_PROPERTY_DEFS.put("securityConfigurationProfileId", new CustomPropertyDef(AbstractSAMLDataConnectorParser.class, "DecryptionSecurityConfigurationProfileId", "value", false, true));
        CUSTOM_PROPERTY_DEFS.put("assertionValidationContextBuilder", new CustomPropertyDef(AbstractSAMLDataConnectorParser.class, "AssertionValidationContextBuilder", "bean", true, true));
        CUSTOM_PROPERTY_DEFS.put("assertionValidator", new CustomPropertyDef(AbstractSAMLDataConnectorParser.class, "AssertionValidator", "bean", true, true));
        CUSTOM_PROPERTY_DEFS.put("transcoderRegistry", new CustomPropertyDef(AbstractSAMLDataConnectorParser.class, "AttributeTranscoderRegistry", "bean", true, true));
        CUSTOM_PROPERTY_DEFS.put("attributeFilterService", new CustomPropertyDef(AbstractSAMLDataConnectorParser.class, "AttributeFilterService", "bean", true, true));
        CUSTOM_PROPERTY_DEFS.put("metadataResolver", new CustomPropertyDef(AbstractSAMLDataConnectorParser.class, "MetadataResolver", "bean", true, true));
    }

    protected static class CustomPropertyValue {
        @Nonnull
        private String value;
        private boolean reference;

        public CustomPropertyValue(@Nonnull String propValue, boolean isReference) {
            this.value = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)propValue), (String)"Property value was null or empty");
            this.reference = isReference;
        }

        @Nonnull
        public String getValue() {
            return this.value;
        }

        public boolean isReference() {
            return this.reference;
        }
    }

    protected static class CustomPropertyDef {
        @Nonnull
        private Class<?> prefix;
        @Nonnull
        private String name;
        @Nonnull
        private String type;
        private boolean reference;
        private boolean required;
        @Nullable
        private String defaultValue;

        protected CustomPropertyDef(@Nonnull Class<?> prefixClass, @Nonnull String propName, @Nonnull String propType, boolean isReference, boolean isRequired) {
            this.prefix = (Class)Constraint.isNotNull(prefixClass, (String)"Prefix class was null");
            this.name = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)propName), (String)"Property name was null or empty");
            this.type = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)propType), (String)"Property name was null or empty");
            this.reference = isReference;
            this.required = isRequired;
        }

        protected CustomPropertyDef(@Nonnull Class<?> prefixClass, @Nonnull String propName, @Nonnull String propType, boolean isReference, boolean isRequired, @Nullable String defaultVal) {
            this(prefixClass, propName, propType, isReference, isRequired);
            this.defaultValue = StringSupport.trimOrNull((String)defaultVal);
        }

        @Nonnull
        public Class<?> getPrefix() {
            return this.prefix;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        @Nonnull
        public String getType() {
            return this.type;
        }

        public boolean isReference() {
            return this.reference;
        }

        public boolean isRequired() {
            return this.required;
        }

        @Nullable
        public String getDefault() {
            return this.defaultValue;
        }
    }
}

