/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc.rdbms.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.StringResultMappingStrategy;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.TemplatedExecutableStatementBuilder;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.impl.DataSourceValidator;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.impl.RDBMSDataConnector;
import net.shibboleth.idp.attribute.resolver.spring.dc.AbstractDataConnectorParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.impl.CacheConfigParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.impl.ManagedConnectionParser;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.spring.util.SpringSupport;
import net.shibboleth.shared.xml.AttributeSupport;
import net.shibboleth.shared.xml.ElementSupport;
import org.slf4j.Logger;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RDBMSDataConnectorParser
extends AbstractDataConnectorParser {
    @Nonnull
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:resolver", "RelationalDatabase");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(RDBMSDataConnectorParser.class);

    @Nullable
    protected Class<RDBMSDataConnector> getBeanClass(@Nonnull Element element) {
        return RDBMSDataConnector.class;
    }

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        this.log.debug("{} Parsing v2 configuration {}", (Object)this.getLogPrefix(), (Object)config);
        V2Parser v2Parser = new V2Parser(config, this.getLogPrefix());
        if (config.hasAttributeNS(null, "failFastInitialize")) {
            builder.addPropertyValue("failFastInitialize", (Object)StringSupport.trimOrNull((String)config.getAttributeNS(null, "failFastInitialize")));
        } else {
            builder.addPropertyValue("failFastInitialize", (Object)FAIL_FAST_DEFAULT);
        }
        String dataSourceID = ManagedConnectionParser.getBeanDataSourceID(config);
        if (dataSourceID != null) {
            builder.addPropertyReference("DataSource", dataSourceID);
        } else {
            builder.addPropertyValue("DataSource", (Object)v2Parser.createManagedDataSource());
        }
        String searchBuilderID = v2Parser.getBeanSearchBuilderID();
        if (searchBuilderID != null) {
            builder.addPropertyReference("executableSearchBuilder", searchBuilderID);
        } else {
            BeanDefinition def = v2Parser.createTemplateBuilder();
            if (def != null) {
                builder.addPropertyValue("executableSearchBuilder", (Object)def);
            }
        }
        String mappingStrategyID = v2Parser.getBeanMappingStrategyID();
        if (mappingStrategyID != null) {
            builder.addPropertyReference("mappingStrategy", mappingStrategyID);
        } else {
            BeanDefinition def = v2Parser.createMappingStrategy();
            if (def != null) {
                builder.addPropertyValue("mappingStrategy", (Object)def);
            }
        }
        String validatorID = v2Parser.getBeanValidatorID();
        if (validatorID != null) {
            builder.addPropertyReference("validator", validatorID);
        } else {
            builder.addPropertyValue("validator", (Object)v2Parser.createValidator());
        }
        String resultCacheBeanID = CacheConfigParser.getBeanResultCacheID(config);
        if (null != resultCacheBeanID) {
            builder.addPropertyReference("resultsCache", resultCacheBeanID);
        } else {
            builder.addPropertyValue("resultsCache", (Object)v2Parser.createCache(parserContext));
        }
        builder.setInitMethodName("initialize");
        builder.setDestroyMethodName("destroy");
    }

    protected static class V2Parser {
        @Nonnull
        private final Element configElement;
        @Nonnull
        private final Logger log = LoggerFactory.getLogger(V2Parser.class);
        @Nonnull
        @NotEmpty
        private final String logPrefix;

        public V2Parser(@Nonnull Element config, @Nonnull @NotEmpty String prefix) {
            Constraint.isNotNull((Object)config, (String)"RelationalDatabase element cannot be null");
            this.configElement = config;
            this.logPrefix = prefix;
        }

        @Nullable
        public BeanDefinition createManagedDataSource() {
            ManagedConnectionParser parser = new ManagedConnectionParser(this.configElement);
            return parser.createDataSource();
        }

        @Nullable
        public String getBeanSearchBuilderID() {
            return AttributeSupport.getAttributeValue((Element)this.configElement, null, (String)"executableSearchBuilderRef");
        }

        @Nonnull
        public BeanDefinition createTemplateBuilder() {
            List queryTemplates;
            BeanDefinitionBuilder templateBuilder = BeanDefinitionBuilder.genericBeanDefinition(TemplatedExecutableStatementBuilder.class);
            templateBuilder.setInitMethodName("initialize");
            templateBuilder.setDestroyMethodName("destroy");
            String velocityEngineRef = StringSupport.trimOrNull((String)this.configElement.getAttribute("templateEngine"));
            if (null == velocityEngineRef) {
                velocityEngineRef = "shibboleth.VelocityEngine";
            }
            templateBuilder.addPropertyReference("velocityEngine", velocityEngineRef);
            String queryTimeout = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("queryTimeout"));
            if (queryTimeout != null) {
                templateBuilder.addPropertyValue("queryTimeout", (Object)queryTimeout);
            }
            if ((queryTemplates = ElementSupport.getChildElementsByTagNameNS((Node)this.configElement, (String)"urn:mace:shibboleth:2.0:resolver", (String)"QueryTemplate")).size() > 1) {
                this.log.warn("{} A maximum of 1 <QueryTemplate> should be specified; the first one has been used", (Object)this.getLogPrefix());
            }
            String queryText = !queryTemplates.isEmpty() ? ((Element)queryTemplates.get(0)).getTextContent() : null;
            templateBuilder.addPropertyValue("templateText", (Object)queryText);
            templateBuilder.setInitMethodName("initialize");
            templateBuilder.setDestroyMethodName("destroy");
            return templateBuilder.getBeanDefinition();
        }

        @Nullable
        public String getBeanMappingStrategyID() {
            return AttributeSupport.getAttributeValue((Element)this.configElement, null, (String)"mappingStrategyRef");
        }

        @Nullable
        public BeanDefinition createMappingStrategy() {
            String multipleResultsIsError;
            String noResultIsError;
            BeanDefinitionBuilder mapper = BeanDefinitionBuilder.genericBeanDefinition(StringResultMappingStrategy.class);
            List columns = ElementSupport.getChildElementsByTagNameNS((Node)this.configElement, (String)"urn:mace:shibboleth:2.0:resolver", (String)"Column");
            if (!columns.isEmpty()) {
                ManagedMap renamingMap = new ManagedMap();
                for (Element column : columns) {
                    assert (column != null);
                    String columnName = AttributeSupport.getAttributeValue((Element)column, null, (String)"columnName");
                    String attributeId = AttributeSupport.getAttributeValue((Element)column, null, (String)"attributeID");
                    if (columnName == null || attributeId == null) continue;
                    renamingMap.put((Object)columnName, (Object)attributeId);
                }
                mapper.addPropertyValue("resultRenamingMap", (Object)renamingMap);
            }
            if ((noResultIsError = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("noResultIsError"))) != null) {
                mapper.addPropertyValue("noResultAnError", (Object)SpringSupport.getStringValueAsBoolean((String)noResultIsError));
            }
            if ((multipleResultsIsError = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("multipleResultsIsError"))) != null) {
                mapper.addPropertyValue("multipleResultsAnError", (Object)multipleResultsIsError);
            }
            return mapper.getBeanDefinition();
        }

        @Nullable
        public String getBeanValidatorID() {
            return AttributeSupport.getAttributeValue((Element)this.configElement, null, (String)"validatorRef");
        }

        @Nullable
        public BeanDefinition createValidator() {
            BeanDefinitionBuilder validator = BeanDefinitionBuilder.genericBeanDefinition(DataSourceValidator.class);
            validator.addPropertyValue("throwValidateError", (Object)true);
            return validator.getBeanDefinition();
        }

        @Nullable
        public BeanDefinition createCache(@Nonnull ParserContext parserContext) {
            CacheConfigParser parser = new CacheConfigParser(this.configElement);
            return parser.createCache();
        }

        @Nonnull
        @NotEmpty
        private String getLogPrefix() {
            return this.logPrefix;
        }
    }
}

