/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.dc.impl.StaticDataConnector;
import net.shibboleth.idp.attribute.resolver.spring.dc.AbstractDataConnectorParser;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.xml.ElementSupport;
import org.slf4j.Logger;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StaticDataConnectorParser
extends AbstractDataConnectorParser {
    @Nonnull
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:resolver", "Static");
    @Nonnull
    public static final QName ATTRIBUTE_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resolver", "Attribute");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StaticDataConnectorParser.class);

    @Nullable
    protected final Class<StaticDataConnector> getBeanClass(@Nonnull Element element) {
        return StaticDataConnector.class;
    }

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        List children = ElementSupport.getChildElements((Node)config, (QName)ATTRIBUTE_ELEMENT_NAME);
        ManagedList attributes = new ManagedList(children.size());
        String attrListRef = StringSupport.trimOrNull((String)config.getAttributeNS(null, "attributeListRef"));
        if (null != attrListRef) {
            if (children.size() > 0) {
                this.log.error("{} : 'attributeListRef' is incompatible with <Attribute/> elements, ignoring them", (Object)this.getLogPrefix());
            }
            builder.addPropertyReference("values", attrListRef);
            return;
        }
        for (Element child : children) {
            String attrId = StringSupport.trimOrNull((String)child.getAttributeNS(null, "id"));
            BeanDefinitionBuilder attributeDefn = BeanDefinitionBuilder.genericBeanDefinition(IdPAttribute.class);
            attributeDefn.addConstructorArgValue((Object)attrId);
            List values = ElementSupport.getChildElementsByTagNameNS((Node)child, (String)"urn:mace:shibboleth:2.0:resolver", (String)"Value");
            ManagedList inValues = new ManagedList(values.size());
            for (Element val : values) {
                BeanDefinitionBuilder value = BeanDefinitionBuilder.genericBeanDefinition(StringAttributeValue.class);
                value.addConstructorArgValue((Object)val.getTextContent());
                this.log.trace("{} Attribute: {}, adding value {}", new Object[]{this.getLogPrefix(), attrId, val.getTextContent()});
                inValues.add((Object)value.getBeanDefinition());
            }
            attributeDefn.addPropertyValue("values", (Object)inValues);
            this.log.debug("{} Adding Attribute: {} with {} values", new Object[]{this.getLogPrefix(), attrId, values.size()});
            attributes.add(attributeDefn.getBeanDefinition());
        }
        builder.addPropertyValue("values", (Object)attributes);
    }

    @Override
    protected boolean failOnDependencies() {
        return true;
    }
}

