/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver;

import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.AbstractResolverPlugin;
import net.shibboleth.idp.attribute.resolver.DataConnector;
import net.shibboleth.idp.attribute.resolver.MultipleResultAnErrorResolutionException;
import net.shibboleth.idp.attribute.resolver.NoResultAnErrorResolutionException;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;

@ThreadSafe
public abstract class AbstractDataConnector
extends AbstractResolverPlugin<Map<String, IdPAttribute>>
implements DataConnector {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractDataConnector.class);
    @Nullable
    private String failoverDataConnectorId;
    @Nullable
    private String logPrefix;
    @Nullable
    private Instant lastSuccess;
    @Nullable
    private Instant lastFail;
    @Nonnull
    private Duration noRetryDelay;
    @Nonnull
    @Unmodifiable
    private Collection<String> exportAttributes;

    public AbstractDataConnector() {
        Duration zero = Duration.ZERO;
        assert (zero != null);
        this.noRetryDelay = zero;
        this.exportAttributes = CollectionSupport.emptySet();
    }

    @Override
    @Nullable
    public String getFailoverDataConnectorId() {
        return this.failoverDataConnectorId;
    }

    public void setFailoverDataConnectorId(@Nullable String id) {
        this.checkSetterPreconditions();
        this.failoverDataConnectorId = StringSupport.trimOrNull((String)id);
    }

    public void setLastSuccess(@Nullable Instant time) {
        this.lastSuccess = time;
    }

    @Override
    @Nullable
    public Instant getLastSuccess() {
        return this.lastSuccess;
    }

    public void setLastFail(@Nullable Instant time) {
        this.lastFail = time;
    }

    @Override
    @Nullable
    public Instant getLastFail() {
        return this.lastFail;
    }

    public void setNoRetryDelay(@Nonnull Duration delay) {
        this.checkSetterPreconditions();
        this.noRetryDelay = delay;
    }

    @Override
    @Nonnull
    public Duration getNoRetryDelay() {
        return this.noRetryDelay;
    }

    public void setExportAttributes(@Nonnull Collection<String> what) {
        this.checkSetterPreconditions();
        this.exportAttributes = CollectionSupport.copyToSet(what);
    }

    @Override
    @Nonnull
    @Unmodifiable
    @NotLive
    public Collection<String> getExportAttributes() {
        return this.exportAttributes;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.logPrefix = null;
    }

    @Override
    @Nullable
    @Unmodifiable
    @NotLive
    public final Map<String, IdPAttribute> doResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        Map<String, IdPAttribute> result;
        try {
            result = this.doDataConnectorResolve(resolutionContext, workContext);
            this.setLastSuccess(Instant.now());
        }
        catch (MultipleResultAnErrorResolutionException | NoResultAnErrorResolutionException e) {
            throw e;
        }
        catch (Exception e) {
            this.setLastFail(Instant.now());
            throw e;
        }
        if (null == result) {
            this.log.debug("{} No attributes were produced during resolution", (Object)this.getId());
            return result;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("{} Produced the following {} attributes during resolution {}", new Object[]{this.getLogPrefix(), result.size(), result.keySet()});
            for (String attrName : result.keySet()) {
                IdPAttribute attr = result.get(attrName);
                this.log.debug("{} Attribute '{}': Values '{}'", new Object[]{this.getLogPrefix(), attrName, attr.getValues()});
            }
        }
        return result;
    }

    @Nullable
    @Unmodifiable
    @NotLive
    protected abstract Map<String, IdPAttribute> doDataConnectorResolve(@Nonnull AttributeResolutionContext var1, @Nonnull AttributeResolverWorkContext var2) throws ResolutionException;

    @Override
    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        String prefix = this.logPrefix;
        if (null == prefix) {
            StringBuilder builder = new StringBuilder("Data Connector '").append(this.getId()).append("':");
            prefix = builder.toString();
            assert (prefix != null);
            if (null == this.logPrefix) {
                this.logPrefix = prefix;
            }
        }
        return prefix;
    }
}

