/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.spring.impl;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.filter.AttributeFilterPolicy;
import net.shibboleth.idp.attribute.filter.spring.BaseFilterParser;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.spring.util.SpringSupport;
import net.shibboleth.shared.xml.ElementSupport;
import org.slf4j.Logger;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AttributeFilterPolicyParser
extends BaseFilterParser {
    @Nonnull
    public static final QName ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:afp", "AttributeFilterPolicy");
    @Nonnull
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:afp", "AttributeFilterPolicyType");
    @Nonnull
    private static final QName ATTRIBUTE_RULE = new QName("urn:mace:shibboleth:2.0:afp", "AttributeRule");
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AttributeFilterPolicyParser.class);

    @Nullable
    protected Class<?> getBeanClass(@Nonnull Element arg0) {
        return AttributeFilterPolicy.class;
    }

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        ManagedList<BeanDefinition> requirements;
        super.doParse(config, parserContext, builder);
        String policyId = StringSupport.trimOrNull((String)config.getAttributeNS(null, "id"));
        if (null == policyId) {
            policyId = this.resolveId(config, builder.getBeanDefinition(), parserContext);
        }
        this.log.debug("Parsing configuration for attribute filter policy: {}", (Object)policyId);
        builder.addConstructorArgValue((Object)policyId);
        List policyRequirements = ElementSupport.getChildElements((Node)config, (QName)BaseFilterParser.POLICY_REQUIREMENT_RULE);
        if (policyRequirements != null && policyRequirements.size() > 0 && (requirements = BaseFilterParser.parseCustomElements(policyRequirements, parserContext, builder)) != null) {
            builder.addConstructorArgValue(requirements.get(0));
        }
        List rules = ElementSupport.getChildElements((Node)config, (QName)ATTRIBUTE_RULE);
        ManagedList attributeRules = SpringSupport.parseCustomElements((Collection)rules, (ParserContext)parserContext, (BeanDefinitionBuilder)builder);
        builder.addConstructorArgValue((Object)attributeRules);
    }
}

