/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.metrics.impl;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.Version;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ApplicationObjectSupport;

public class IdPGaugeSet
extends ApplicationObjectSupport
implements MetricSet,
MetricFilter {
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_METRIC_NAME = "net.shibboleth.idp";
    @Nonnull
    private final Map<String, Metric> gauges = new HashMap<String, Metric>();

    public IdPGaugeSet() {
        this.gauges.put(MetricRegistry.name((String)DEFAULT_METRIC_NAME, (String[])new String[]{"version"}), (Metric)new Gauge<String>(){

            public String getValue() {
                return Version.getVersion();
            }
        });
        this.gauges.put("org.opensaml.version", (Metric)new Gauge<String>(){

            public String getValue() {
                return org.opensaml.core.Version.getVersion();
            }
        });
        this.gauges.put(MetricRegistry.name((String)DEFAULT_METRIC_NAME, (String[])new String[]{"starttime"}), (Metric)new Gauge<Instant>(){

            public Instant getValue() {
                ApplicationContext context = IdPGaugeSet.this.getApplicationContext();
                assert (context != null);
                return Instant.ofEpochMilli(context.getStartupDate());
            }
        });
        this.gauges.put(MetricRegistry.name((String)DEFAULT_METRIC_NAME, (String[])new String[]{"uptime"}), (Metric)new Gauge<Duration>(){

            public Duration getValue() {
                ApplicationContext context = IdPGaugeSet.this.getApplicationContext();
                assert (context != null);
                return Duration.ofMillis(Instant.now().toEpochMilli() - context.getStartupDate());
            }
        });
    }

    public void setExposedProperties(@Nullable Set<String> properties) {
        if (properties != null) {
            final ApplicationContext context = this.getApplicationContext();
            assert (context != null);
            for (final String property : properties) {
                assert (property != null);
                this.gauges.put(MetricRegistry.name((String)DEFAULT_METRIC_NAME, (String[])new String[]{"properties", property}), (Metric)new Gauge<String>(){

                    public String getValue() {
                        return context.getEnvironment().getProperty(property);
                    }
                });
            }
        }
    }

    public Map<String, Metric> getMetrics() {
        return Map.copyOf(this.gauges);
    }

    public boolean matches(String name, Metric metric) {
        return this.gauges.containsKey(name);
    }

    protected boolean isContextRequired() {
        return true;
    }
}

