/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.module;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.profile.module.Module;
import net.shibboleth.profile.module.ModuleContext;
import net.shibboleth.profile.module.ModuleException;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.spring.httpclient.resource.ConnectionClosingInputStream;
import org.apache.commons.lang3.SystemUtils;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.HttpClientSecuritySupport;
import org.slf4j.Logger;
import org.springframework.core.io.ClassPathResource;

public abstract class AbstractModule
implements Module {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AbstractModule.class);
    @Nonnull
    private Collection<Module.ModuleResource> moduleResources = CollectionSupport.emptyList();
    @Nonnull
    private String appNewExt;

    protected AbstractModule(@Nullable String version) {
        this.appNewExt = version != null ? this.getNewExtension() + "-" + version.replace(".", "") : this.getNewExtension();
    }

    @Override
    @Nonnull
    @NotLive
    @Unmodifiable
    public Collection<Module.ModuleResource> getResources() {
        return this.moduleResources;
    }

    public void setResources(@Nullable Collection<BasicModuleResource> resources) {
        this.moduleResources = resources != null ? CollectionSupport.copyToList(resources) : CollectionSupport.emptyList();
    }

    @Override
    public boolean isEnabled(@Nonnull ModuleContext moduleContext) {
        this.log.debug("Module {} checking enabled status", (Object)this.getId());
        if (this.moduleResources.isEmpty()) {
            this.log.debug("Module {} is always enabled", (Object)this.getId());
            return true;
        }
        for (Module.ModuleResource resource : this.moduleResources) {
            if (resource.isOptional()) continue;
            if (moduleContext.getInstallLocation().startsWith("classpath:")) {
                ClassPathResource cp;
                if (moduleContext.getInstallLocation().equals("classpath:")) {
                    resourceString = resource.getDestination().toString();
                    assert (resourceString != null);
                    cp = new ClassPathResource(resourceString);
                } else {
                    resourceString = moduleContext.getInstallLocation().substring("classpath:".length());
                    String relString = resource.getDestination().toString();
                    assert (resourceString != null && relString != null);
                    cp = (ClassPathResource)new ClassPathResource(resourceString).createRelative(relString);
                }
                if (cp.exists()) continue;
                this.log.debug("Module {}: resource destination {} missing, module is disabled", (Object)this.getId(), (Object)("classpath:" + cp.getPath()));
                return false;
            }
            Path resolved = Path.of(moduleContext.getInstallLocation(), new String[0]).resolve(resource.getDestination());
            if (SystemUtils.IS_OS_WINDOWS && resource.isWindows() && !resolved.toFile().exists()) {
                this.log.debug("Module {}: resource destination {} missing, module is disabled", (Object)this.getId(), (Object)resolved);
                return false;
            }
            if (SystemUtils.IS_OS_WINDOWS || !resource.isNonWindows() || resolved.toFile().exists()) continue;
            this.log.debug("Module {}: resource destination {} missing, module is disabled", (Object)this.getId(), (Object)resolved);
            return false;
        }
        this.log.debug("Module {} is enabled", (Object)this.getId());
        return true;
    }

    @Override
    @Nonnull
    @Unmodifiable
    @NotLive
    public Map<Module.ModuleResource, Module.ResourceResult> enable(@Nonnull ModuleContext moduleContext) throws ModuleException {
        LinkedHashMap<Module.ModuleResource, Module.ResourceResult> results;
        if (moduleContext.getInstallLocation().startsWith("classpath:")) {
            throw new ModuleException("IdP location is a classpath");
        }
        if (this.isHttpClientRequired() && moduleContext.getHttpClient() == null) {
            throw new ModuleException("HTTP client required but not available");
        }
        assert (moduleContext.getOperationType() != ModuleContext.OperationType.Unknown);
        this.log.debug("Module {} enabling", (Object)this.getId());
        if (!this.moduleResources.isEmpty()) {
            results = new LinkedHashMap<Module.ModuleResource, Module.ResourceResult>(this.moduleResources.size());
            for (Module.ModuleResource resource : this.moduleResources) {
                if (SystemUtils.IS_OS_WINDOWS) {
                    if (resource.isWindows()) {
                        results.put(resource, ((BasicModuleResource)resource).enable(moduleContext));
                        continue;
                    }
                    this.log.debug("Module {}: skipping non-Windows resource {}", (Object)this.getId(), (Object)resource);
                    continue;
                }
                if (resource.isNonWindows()) {
                    results.put(resource, ((BasicModuleResource)resource).enable(moduleContext));
                    continue;
                }
                this.log.debug("Module {}: skipping Windows resource {}", (Object)this.getId(), (Object)resource);
            }
        } else {
            results = CollectionSupport.emptyMap();
        }
        this.log.debug("Module {} enabled", (Object)this.getId());
        assert (results != null);
        return results;
    }

    @Override
    @Nonnull
    @Unmodifiable
    @NotLive
    public Map<Module.ModuleResource, Module.ResourceResult> disable(@Nonnull ModuleContext moduleContext, boolean clean) throws ModuleException {
        LinkedHashMap<Module.ModuleResource, Module.ResourceResult> results;
        if (moduleContext.getInstallLocation().startsWith("classpath:")) {
            throw new ModuleException("IdP location is a classpath");
        }
        this.log.debug("Module {} disabling", (Object)this.getId());
        assert (moduleContext.getOperationType() != ModuleContext.OperationType.Unknown);
        if (!this.moduleResources.isEmpty()) {
            results = new LinkedHashMap<Module.ModuleResource, Module.ResourceResult>(this.moduleResources.size());
            for (Module.ModuleResource resource : this.moduleResources) {
                if (SystemUtils.IS_OS_WINDOWS) {
                    if (!resource.isWindows()) continue;
                    results.put(resource, ((BasicModuleResource)resource).disable(moduleContext, clean));
                    continue;
                }
                if (!resource.isNonWindows()) continue;
                results.put(resource, ((BasicModuleResource)resource).disable(moduleContext, clean));
            }
        } else {
            results = CollectionSupport.emptyMap();
        }
        this.log.debug("Module {} disabled", (Object)this.getId());
        assert (results != null);
        return results;
    }

    public boolean equals(Object obj) {
        return obj instanceof Module && Objects.equals(this.getId(), ((Module)obj).getId());
    }

    public int hashCode() {
        return ((String)Constraint.isNotNull((Object)this.getId(), (String)"ID cannot be null")).hashCode();
    }

    public String toString() {
        return "IdPModule " + this.getId();
    }

    protected class BasicModuleResource
    implements Module.ModuleResource {
        @Nonnull
        @NotEmpty
        private final String source;
        @Nonnull
        private final Path destination;
        private final boolean replace;
        private final boolean optional;
        private final boolean executable;
        private final boolean windows;
        private final boolean nonwindows;

        public BasicModuleResource(@Nonnull String src, Path dest, boolean shouldReplace, boolean isOptional, boolean isExecutable, boolean isWindows, boolean isNonWindows) {
            this.source = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)src), (String)"Source cannot be null");
            this.destination = (Path)Constraint.isNotNull((Object)dest, (String)"Destination cannot be null");
            this.replace = shouldReplace;
            this.optional = isOptional;
            this.executable = isExecutable;
            this.windows = isWindows;
            this.nonwindows = isNonWindows;
        }

        public int hashCode() {
            return this.source.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Module.ModuleResource) {
                return this.source.equals(((Module.ModuleResource)obj).getSource()) && this.destination.equals(((Module.ModuleResource)obj).getDestination());
            }
            return false;
        }

        @Override
        @Nonnull
        public String getSource() {
            return this.source;
        }

        @Override
        @Nonnull
        public Path getDestination() {
            return this.destination;
        }

        @Override
        public boolean isReplace() {
            return this.replace;
        }

        @Override
        public boolean isOptional() {
            return this.optional;
        }

        @Override
        public boolean isExecutable() {
            return this.executable;
        }

        @Override
        public boolean isWindows() {
            return this.windows;
        }

        @Override
        public boolean isNonWindows() {
            return this.nonwindows;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public boolean hasChanged(@Nonnull ModuleContext moduleContext) {
            try {
                InputStream dest = this.getDestinationStream(moduleContext);
                if (dest != null) {
                    byte[] destHash;
                    MessageDigest digest = MessageDigest.getInstance("SHA1");
                    try (OutputStream destSink = OutputStream.nullOutputStream();
                         DigestOutputStream destDigest = new DigestOutputStream(destSink, digest);){
                        dest.transferTo(destDigest);
                        destHash = digest.digest();
                    }
                    InputStream src = this.getSourceStream(moduleContext);
                    if (src != null) {
                        try (OutputStream srcSink = OutputStream.nullOutputStream();){
                            boolean bl;
                            try (DigestOutputStream srcDigest = new DigestOutputStream(srcSink, digest);){
                                src.transferTo(srcDigest);
                                bl = !Arrays.equals(destHash, digest.digest());
                            }
                            return bl;
                        }
                    }
                    AbstractModule.this.log.debug("Module {} resource {} does not exist at source", (Object)AbstractModule.this.getId(), (Object)this.source);
                    boolean bl = true;
                    return bl;
                    finally {
                        if (src != null) {
                            src.close();
                        }
                    }
                }
                AbstractModule.this.log.debug("Module {} resource {} does not exist at destination", (Object)AbstractModule.this.getId(), (Object)this.source);
                boolean bl = false;
                return bl;
                finally {
                    if (dest != null) {
                        dest.close();
                    }
                }
            }
            catch (IOException e) {
                AbstractModule.this.log.error("Module {} resource {} raised error while checking contents", new Object[]{AbstractModule.this.getId(), this.source, e});
                return true;
            }
            catch (NoSuchAlgorithmException e) {
                AbstractModule.this.log.error("Module {} resource {} raised error while checking contents", new Object[]{AbstractModule.this.getId(), this.source, e});
                return true;
            }
        }

        @Nullable
        private InputStream getSourceStream(@Nonnull ModuleContext moduleContext) throws IOException {
            if (this.source.startsWith("https://") || this.source.startsWith("http://")) {
                try {
                    return this.connect(moduleContext, new URI(this.source));
                }
                catch (URISyntaxException e) {
                    throw new IOException(e);
                }
            }
            return AbstractModule.this.getClass().getResourceAsStream(this.source);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nonnull
        private InputStream connect(@Nonnull ModuleContext moduleContext, @Nonnull URI uri) throws IOException {
            HttpClientContext clientContext = HttpClientContext.create();
            assert (clientContext != null);
            HttpClientSecuritySupport.marshalSecurityParameters((HttpClientContext)clientContext, (HttpClientSecurityParameters)moduleContext.getHttpClientSecurityParameters(), (boolean)true);
            ClassicHttpResponse response = null;
            try {
                AbstractModule.this.log.debug("Module {} fetching HTTP resource {}", (Object)AbstractModule.this.getId(), (Object)uri);
                HttpGet request = new HttpGet(uri);
                response = ((HttpClient)Constraint.isNotNull((Object)moduleContext.getHttpClient(), (String)"HttpClient cannot be null")).executeOpen(null, (ClassicHttpRequest)request, (HttpContext)clientContext);
                String scheme = request.getScheme();
                assert (scheme != null);
                HttpClientSecuritySupport.checkTLSCredentialEvaluated((HttpClientContext)clientContext, (String)scheme);
                if (response.getCode() != 200) {
                    throw new IOException("HTTP request was unsuccessful");
                }
                ConnectionClosingInputStream ret = new ConnectionClosingInputStream(response);
                response = null;
                ConnectionClosingInputStream connectionClosingInputStream = ret;
                return connectionClosingInputStream;
            }
            finally {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (IOException e) {
                        AbstractModule.this.log.debug("Error closing HttpResponse", (Throwable)e);
                    }
                }
            }
        }

        @Nullable
        private InputStream getDestinationStream(@Nonnull ModuleContext moduleContext) throws IOException {
            Path destPath = Path.of(moduleContext.getInstallLocation(), new String[0]).resolve(this.destination);
            if (Files.exists(destPath, new LinkOption[0])) {
                try {
                    return Files.newInputStream(destPath, StandardOpenOption.READ);
                }
                catch (IOException e) {
                    AbstractModule.this.log.error("Module {} unable to read destination resource {}", new Object[]{AbstractModule.this.getId(), destPath, e});
                }
            }
            return null;
        }

        @Nonnull
        private Module.ResourceResult enable(@Nonnull ModuleContext moduleContext) throws ModuleException {
            Module.ResourceResult resourceResult;
            block19: {
                AbstractModule.this.log.debug("Module {} enabling resource {}", (Object)AbstractModule.this.getId(), (Object)this.source);
                boolean hasChanged = this.hasChanged(moduleContext);
                InputStream srcStream = this.getSourceStream(moduleContext);
                try {
                    Module.ResourceResult result;
                    Path destPath;
                    if (srcStream == null) {
                        throw new IOException("Source stream was null");
                    }
                    if (hasChanged) {
                        if (this.isReplace()) {
                            destPath = Path.of(moduleContext.getInstallLocation(), new String[0]).resolve(this.destination);
                            Path savedPath = destPath.resolveSibling(String.valueOf(destPath.getFileName()) + AbstractModule.this.getSaveExtension());
                            if (savedPath.toFile().exists()) {
                                AbstractModule.this.log.warn("Module {} overwriting older saved file: {}", (Object)AbstractModule.this.getId(), (Object)savedPath);
                            }
                            Files.copy(destPath, savedPath, StandardCopyOption.REPLACE_EXISTING);
                            AbstractModule.this.log.debug("Module {} preserved {}", (Object)AbstractModule.this.getId(), (Object)destPath);
                            result = Module.ResourceResult.REPLACED;
                        } else {
                            Path basePath = Path.of(moduleContext.getInstallLocation(), new String[0]).resolve(this.destination);
                            destPath = basePath.resolveSibling(String.valueOf(basePath.getFileName()) + AbstractModule.this.appNewExt);
                            result = Module.ResourceResult.ADDED;
                        }
                    } else {
                        destPath = Path.of(moduleContext.getInstallLocation(), new String[0]).resolve(this.destination);
                        result = Module.ResourceResult.CREATED;
                    }
                    if (!destPath.startsWith(moduleContext.getInstallLocation())) {
                        AbstractModule.this.log.error("Module {} attempted to create file outside of IdP installation: {}", (Object)AbstractModule.this.getId(), (Object)destPath);
                        throw new ModuleException("Module asked to create file outside of IdP installation");
                    }
                    try {
                        Files.createDirectories(destPath.getParent(), new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        if (e instanceof FileAlreadyExistsException) {
                            AbstractModule.this.log.info("Path {} existed but not directory, assuming symlink", (Object)destPath.getParent());
                        }
                        throw e;
                    }
                    Files.copy(srcStream, destPath, StandardCopyOption.REPLACE_EXISTING);
                    if (this.isExecutable()) {
                        destPath.toFile().setExecutable(true);
                    }
                    AbstractModule.this.log.debug("Module {} created {}", (Object)AbstractModule.this.getId(), (Object)destPath);
                    resourceResult = result;
                    if (srcStream == null) break block19;
                }
                catch (Throwable throwable) {
                    try {
                        if (srcStream != null) {
                            try {
                                srcStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        AbstractModule.this.log.error("Module {} unable to enable resource {}", (Object)AbstractModule.this.getId(), (Object)this.source);
                        throw new ModuleException(e);
                    }
                }
                srcStream.close();
            }
            return resourceResult;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nonnull
        private Module.ResourceResult disable(@Nonnull ModuleContext moduleContext, boolean clean) throws ModuleException {
            Path resolved = Path.of(moduleContext.getInstallLocation(), new String[0]).resolve(this.destination);
            AbstractModule.this.log.debug("Module {} resolved resource destination {}", (Object)AbstractModule.this.getId(), (Object)resolved);
            if (Files.exists(resolved, new LinkOption[0])) {
                try {
                    Module.ResourceResult result;
                    if (clean || !this.hasChanged(moduleContext)) {
                        AbstractModule.this.log.debug("Module {} removing resource {}", (Object)AbstractModule.this.getId(), (Object)resolved);
                        Files.delete(resolved);
                        result = Module.ResourceResult.REMOVED;
                    } else {
                        AbstractModule.this.log.debug("Module {} backing up resource {}", (Object)AbstractModule.this.getId(), (Object)resolved);
                        Files.move(resolved, resolved.resolveSibling(String.valueOf(resolved.getFileName()) + AbstractModule.this.getSaveExtension()), StandardCopyOption.REPLACE_EXISTING);
                        result = Module.ResourceResult.SAVED;
                    }
                    Path idpnewVersion = resolved.resolveSibling(String.valueOf(resolved.getFileName()) + AbstractModule.this.appNewExt);
                    if (!Files.exists(idpnewVersion, new LinkOption[0])) return result;
                    Files.delete(idpnewVersion);
                    return result;
                }
                catch (IOException e) {
                    AbstractModule.this.log.error("Module {} failed to disable {}", (Object)AbstractModule.this.getId(), (Object)resolved);
                    throw new ModuleException(e);
                }
            } else {
                AbstractModule.this.log.debug("Module {} resource {} missing, ignoring", (Object)AbstractModule.this.getId(), (Object)resolved);
                return Module.ResourceResult.MISSING;
            }
        }
    }
}

