/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.context.logic;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.profile.context.logic.AbstractAttributePredicate;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;

public class SimpleAttributePredicate
extends AbstractAttributePredicate {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SimpleAttributePredicate.class);
    @Nonnull
    private ListMultimap<String, String> attributeValueMap = ArrayListMultimap.create();
    @Nullable
    @NotEmpty
    private String scope;

    public void setAttributeValueMap(@Nonnull Map<String, Collection<String>> map) {
        Constraint.isNotNull(map, (String)"Attribute/value map cannot be null");
        this.attributeValueMap.clear();
        for (Map.Entry<String, Collection<String>> entry : map.entrySet()) {
            String attributeId = StringSupport.trimOrNull((String)entry.getKey());
            this.attributeValueMap.putAll((Object)attributeId, (Iterable)StringSupport.normalizeStringCollection(entry.getValue()));
        }
    }

    public void setScope(@Nullable @NotEmpty String s) {
        this.scope = StringSupport.trimOrNull((String)s);
    }

    @Override
    protected boolean allowNullAttributeContext() {
        return this.attributeValueMap.isEmpty() && this.scope == null;
    }

    @Override
    protected boolean hasMatch(@Nonnull Map<String, IdPAttribute> attributeMap) {
        for (String id : this.attributeValueMap.keySet()) {
            this.log.debug("Checking for attribute: {}", (Object)id);
            IdPAttribute attribute = attributeMap.get(id);
            if (attribute == null) {
                this.log.debug("Attribute {} not found in context", (Object)id);
                return false;
            }
            boolean matched = false;
            for (String value : this.attributeValueMap.get((Object)id)) {
                assert (value != null);
                if (!this.findMatch(value, attribute)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            this.log.debug("Attribute {} values not matched", (Object)id);
            return false;
        }
        return true;
    }

    protected boolean findMatch(@Nonnull @NotEmpty String toMatch, @Nonnull IdPAttribute attribute) {
        if ("*".equals(toMatch) && this.scope == null) {
            this.log.debug("Wildcard (*) value rule for attribute {}", (Object)attribute.getId());
            return true;
        }
        for (IdPAttributeValue value : attribute.getValues()) {
            if (this.scope != null && value instanceof ScopedStringAttributeValue) {
                String scopeCopy = this.scope;
                if (!"*".equals(toMatch) && !toMatch.equals(((ScopedStringAttributeValue)value).getValue()) || !"*".equals(scopeCopy) && !scopeCopy.equals(((ScopedStringAttributeValue)value).getScope())) continue;
                this.log.debug("Found matching value ({}) and scope ({}) in attribute {}", new Object[]{toMatch, scopeCopy, attribute.getId()});
                return true;
            }
            if (this.scope != null || !(value instanceof StringAttributeValue) || !toMatch.equals(((StringAttributeValue)value).getValue())) continue;
            this.log.debug("Found matching value ({}) in attribute {}", (Object)toMatch, (Object)attribute.getId());
            return true;
        }
        return false;
    }
}

