/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.config.navigate;

import javax.annotation.Nullable;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.config.navigate.AbstractDefaultSecurityConfigurationLookupFunction;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.config.SecurityConfiguration;

public class IdentifierGenerationStrategyLookupFunction
extends AbstractDefaultSecurityConfigurationLookupFunction<IdentifierGenerationStrategy> {
    @Nullable
    private IdentifierGenerationStrategy defaultGenerator;

    public void setDefaultIdentifierGenerationStrategy(@Nullable IdentifierGenerationStrategy strategy) {
        this.defaultGenerator = strategy;
    }

    @Nullable
    public IdentifierGenerationStrategy apply(@Nullable ProfileRequestContext input) {
        RelyingPartyContext rpc = this.getRelyingPartyContextLookupStrategy().apply(input);
        if (rpc != null) {
            SecurityConfiguration sc;
            ProfileConfiguration pc = rpc.getProfileConfig();
            if (pc != null && (sc = pc.getSecurityConfiguration(input)) != null) {
                return sc.getIdGenerator();
            }
            SecurityConfiguration defaultConfig = this.getDefaultSecurityConfiguration(rpc.getConfiguration(), input);
            if (defaultConfig != null && defaultConfig.getIdGenerator() != null) {
                return defaultConfig.getIdGenerator();
            }
        }
        return this.defaultGenerator;
    }
}

