/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.config.navigate;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.config.navigate.AbstractDefaultSecurityConfigurationLookupFunction;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.constraint.Live;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.config.SecurityConfiguration;
import org.opensaml.xmlsec.DecryptionConfiguration;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.config.XMLSecurityConfiguration;

public class DecryptionConfigurationLookupFunction
extends AbstractDefaultSecurityConfigurationLookupFunction<List<DecryptionConfiguration>> {
    @Nullable
    @Live
    public List<DecryptionConfiguration> apply(@Nullable ProfileRequestContext input) {
        ArrayList<DecryptionConfiguration> configs = new ArrayList<DecryptionConfiguration>();
        RelyingPartyContext rpc = this.getRelyingPartyContextLookupStrategy().apply(input);
        if (rpc != null) {
            SecurityConfiguration defaultConfig;
            XMLSecurityConfiguration xsc;
            SecurityConfiguration sc;
            ProfileConfiguration pc = rpc.getProfileConfig();
            if (pc != null && (sc = pc.getSecurityConfiguration(input)) instanceof XMLSecurityConfiguration && (xsc = (XMLSecurityConfiguration)sc).getDecryptionConfiguration() != null) {
                configs.add(xsc.getDecryptionConfiguration());
            }
            if ((defaultConfig = this.getDefaultSecurityConfiguration(rpc.getConfiguration(), input)) instanceof XMLSecurityConfiguration && (xsc = (XMLSecurityConfiguration)defaultConfig).getDecryptionConfiguration() != null) {
                configs.add(xsc.getDecryptionConfiguration());
            }
        }
        configs.add(SecurityConfigurationSupport.getGlobalDecryptionConfiguration());
        return configs;
    }
}

