/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter;

import java.util.Set;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.filter.BaseBridgingClass;
import net.shibboleth.idp.attribute.filter.Matcher;
import net.shibboleth.idp.attribute.filter.PolicyRequirementRule;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.component.DestructableComponent;
import net.shibboleth.shared.component.IdentifiedComponent;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public final class PolicyFromMatcher
extends BaseBridgingClass
implements PolicyRequirementRule,
IdentifiedComponent,
DestructableComponent {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PolicyFromMatcher.class);
    @Nonnull
    private final Matcher matcher;

    public PolicyFromMatcher(@Nonnull @ParameterName(name="theMatcher") Matcher theMatcher) {
        super(theMatcher);
        this.matcher = theMatcher;
    }

    @Nonnull
    public Matcher getMatcher() {
        return this.matcher;
    }

    @Override
    @Nonnull
    public PolicyRequirementRule.Tristate matches(@Nonnull AttributeFilterContext context) {
        this.log.debug("{} Applying matcher supplied as policy to all values of all attributes", (Object)this.getLogPrefix());
        for (IdPAttribute attribute : context.getPrefilteredIdPAttributes().values()) {
            assert (attribute != null);
            Set<IdPAttributeValue> result = this.matcher.getMatchingValues(attribute, context);
            if (null == result) {
                this.log.warn("{} Matcher returned null, returning FAIL", (Object)this.getLogPrefix());
                return PolicyRequirementRule.Tristate.FAIL;
            }
            if (result.isEmpty()) continue;
            this.log.debug("{} Matcher returned some values.  Return TRUE", (Object)this.getLogPrefix());
            return PolicyRequirementRule.Tristate.TRUE;
        }
        this.log.debug("{} Matcher returned no values for any attribute.  Return FALSE", (Object)this.getLogPrefix());
        return PolicyRequirementRule.Tristate.FALSE;
    }
}

