/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.service.impl;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.cas.service.Service;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.saml.metadata.EntityGroupName;
import org.opensaml.saml.saml2.metadata.AdditionalMetadataLocation;
import org.opensaml.saml.saml2.metadata.AffiliationDescriptor;
import org.opensaml.saml.saml2.metadata.AttributeAuthorityDescriptor;
import org.opensaml.saml.saml2.metadata.AuthnAuthorityDescriptor;
import org.opensaml.saml.saml2.metadata.ContactPerson;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.Organization;
import org.opensaml.saml.saml2.metadata.PDPDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.xmlsec.signature.Signature;

public class ServiceEntityDescriptor
extends AbstractXMLObject
implements EntityDescriptor {
    @Nonnull
    private final Service svc;

    public ServiceEntityDescriptor(@Nonnull Service service) {
        super("urn:oasis:names:tc:SAML:2.0:metadata", "EntityDescriptor", "md");
        this.svc = (Service)Constraint.isNotNull((Object)service, (String)"Service cannot be null");
        String group = service.getGroup();
        if (StringSupport.trimOrNull((String)group) != null) {
            assert (group != null);
            this.getObjectMetadata().put((Object)new EntityGroupName(group));
        }
    }

    @Nullable
    public String getEntityID() {
        return this.svc.getName();
    }

    public void setEntityID(@Nullable String id) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public String getID() {
        return null;
    }

    public void setID(@Nullable String newID) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public Extensions getExtensions() {
        return null;
    }

    public void setExtensions(@Nullable Extensions extensions) {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    @Live
    public List<RoleDescriptor> getRoleDescriptors() {
        return CollectionSupport.emptyList();
    }

    @Nonnull
    @Live
    public List<RoleDescriptor> getRoleDescriptors(@Nonnull QName typeOrName) {
        return CollectionSupport.emptyList();
    }

    @Nonnull
    @Live
    public List<RoleDescriptor> getRoleDescriptors(@Nonnull QName typeOrName, @Nonnull String supportedProtocol) {
        return CollectionSupport.emptyList();
    }

    @Nullable
    public IDPSSODescriptor getIDPSSODescriptor(@Nonnull String supportedProtocol) {
        return null;
    }

    @Nullable
    public SPSSODescriptor getSPSSODescriptor(@Nonnull String supportedProtocol) {
        return null;
    }

    @Nullable
    public AuthnAuthorityDescriptor getAuthnAuthorityDescriptor(@Nonnull String supportedProtocol) {
        return null;
    }

    @Nullable
    public AttributeAuthorityDescriptor getAttributeAuthorityDescriptor(@Nonnull String supportedProtocol) {
        return null;
    }

    @Nullable
    public PDPDescriptor getPDPDescriptor(@Nonnull String supportedProtocol) {
        return null;
    }

    @Nullable
    public AffiliationDescriptor getAffiliationDescriptor() {
        return null;
    }

    public void setAffiliationDescriptor(@Nullable AffiliationDescriptor descriptor) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public Organization getOrganization() {
        return null;
    }

    public void setOrganization(@Nullable Organization organization) {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    @Live
    public List<ContactPerson> getContactPersons() {
        return CollectionSupport.emptyList();
    }

    @Nonnull
    @Live
    public List<AdditionalMetadataLocation> getAdditionalMetadataLocations() {
        return CollectionSupport.emptyList();
    }

    @Nonnull
    public AttributeMap getUnknownAttributes() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public Duration getCacheDuration() {
        return null;
    }

    public void setCacheDuration(@Nullable Duration duration) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public String getSignatureReferenceID() {
        return null;
    }

    public boolean isSigned() {
        return false;
    }

    @Nullable
    public Signature getSignature() {
        return null;
    }

    public void setSignature(@Nullable Signature newSignature) {
        throw new UnsupportedOperationException();
    }

    public boolean isValid() {
        return true;
    }

    @Nullable
    public Instant getValidUntil() {
        return Instant.now().plus(1L, ChronoUnit.DAYS);
    }

    public void setValidUntil(@Nullable Instant validUntil) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    @Unmodifiable
    @NotLive
    public List<XMLObject> getOrderedChildren() {
        return null;
    }
}

