/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.config.ConfigLookupFunction;
import net.shibboleth.idp.cas.config.ValidateConfiguration;
import net.shibboleth.idp.cas.flow.impl.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.protocol.ProtocolError;
import net.shibboleth.idp.cas.protocol.ProtocolParam;
import net.shibboleth.idp.cas.protocol.TicketValidationRequest;
import net.shibboleth.idp.cas.protocol.TicketValidationResponse;
import net.shibboleth.idp.cas.proxy.ProxyIdentifiers;
import net.shibboleth.idp.cas.proxy.ProxyValidator;
import net.shibboleth.idp.cas.ticket.ProxyGrantingTicket;
import net.shibboleth.idp.cas.ticket.ProxyTicket;
import net.shibboleth.idp.cas.ticket.ServiceTicket;
import net.shibboleth.idp.cas.ticket.Ticket;
import net.shibboleth.idp.cas.ticket.TicketService;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import org.apache.hc.core5.net.URIBuilder;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.action.EventException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.config.SecurityConfiguration;
import org.slf4j.Logger;

public class ValidateProxyCallbackAction
extends AbstractCASProtocolAction<TicketValidationRequest, TicketValidationResponse> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateProxyCallbackAction.class);
    @Nonnull
    private final ConfigLookupFunction<ValidateConfiguration> configLookupFunction;
    @Nonnull
    private final ProxyValidator proxyValidator;
    @Nonnull
    private final TicketService casTicketService;
    @NonnullBeforeExec
    private ValidateConfiguration validateConfig;
    @NonnullBeforeExec
    private SecurityConfiguration securityConfig;
    @NonnullBeforeExec
    private Ticket ticket;
    @NonnullBeforeExec
    private TicketValidationRequest request;
    @NonnullBeforeExec
    private TicketValidationResponse response;

    public ValidateProxyCallbackAction(@Nonnull ProxyValidator validator, @Nonnull TicketService ticketService) {
        this.proxyValidator = (ProxyValidator)Constraint.isNotNull((Object)validator, (String)"ProxyValidator cannot be null");
        this.casTicketService = (TicketService)Constraint.isNotNull((Object)ticketService, (String)"TicketService cannot be null");
        this.configLookupFunction = new ConfigLookupFunction(ValidateConfiguration.class);
    }

    @Nonnull
    private Ticket getTicket() {
        assert (this.isPreExecuteCalled());
        return this.ticket;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.validateConfig = (ValidateConfiguration)this.configLookupFunction.apply(profileRequestContext);
        if (this.validateConfig == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        this.securityConfig = this.validateConfig.getSecurityConfiguration(profileRequestContext);
        if (this.securityConfig == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSecurityConfiguration");
            return false;
        }
        try {
            this.ticket = this.getCASTicket(profileRequestContext);
            this.request = (TicketValidationRequest)this.getCASRequest(profileRequestContext);
            this.response = (TicketValidationResponse)this.getCASResponse(profileRequestContext);
        }
        catch (EventException e) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)e.getEventID());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        URI proxyCallbackUri;
        IdentifierGenerationStrategy pgtGenerator = this.securityConfig.getIdGenerator();
        IdentifierGenerationStrategy pgtIOUGenerator = this.validateConfig.getPGTIOUGenerator(profileRequestContext);
        Instant expiration = Instant.now().plus(this.validateConfig.getTicketValidityPeriod(profileRequestContext));
        assert (expiration != null);
        String pgtId = pgtGenerator.generateIdentifier();
        String pgtUrl = this.request.getPgtUrl();
        assert (pgtUrl != null);
        ProxyGrantingTicket pgt = this.getTicket() instanceof ServiceTicket ? this.casTicketService.createProxyGrantingTicket(pgtId, expiration, (ServiceTicket)this.getTicket(), pgtUrl) : this.casTicketService.createProxyGrantingTicket(pgtId, expiration, (ProxyTicket)this.getTicket(), pgtUrl);
        ProxyIdentifiers proxyIds = new ProxyIdentifiers(pgt.getId(), pgtIOUGenerator.generateIdentifier());
        try {
            proxyCallbackUri = new URIBuilder(this.request.getPgtUrl()).addParameter(ProtocolParam.PgtId.id(), proxyIds.getPgtId()).addParameter(ProtocolParam.PgtIou.id(), proxyIds.getPgtIou()).build();
        }
        catch (URISyntaxException e) {
            this.log.warn("{} Error creating proxy callback URL", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"RuntimeException");
            return;
        }
        assert (proxyCallbackUri != null);
        try {
            this.log.debug("{} Attempting proxy authentication to {}", (Object)this.getLogPrefix(), (Object)proxyCallbackUri);
            this.proxyValidator.validate(profileRequestContext, proxyCallbackUri);
            this.response.setPgtIou(proxyIds.getPgtIou());
        }
        catch (Exception e) {
            this.log.warn("{} Proxy authentication failed for {}", new Object[]{this.getLogPrefix(), this.request.getPgtUrl(), e});
            this.casTicketService.removeProxyGrantingTicket(pgt.getId());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (Object)ProtocolError.ProxyCallbackAuthenticationFailure.event((Object)this));
        }
    }
}

