/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import java.time.Instant;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.authn.context.navigate.SubjectContextPrincipalLookupFunction;
import net.shibboleth.idp.cas.config.ConfigLookupFunction;
import net.shibboleth.idp.cas.config.LoginConfiguration;
import net.shibboleth.idp.cas.flow.impl.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.protocol.ProtocolError;
import net.shibboleth.idp.cas.protocol.ServiceTicketRequest;
import net.shibboleth.idp.cas.protocol.ServiceTicketResponse;
import net.shibboleth.idp.cas.ticket.ServiceTicket;
import net.shibboleth.idp.cas.ticket.Ticket;
import net.shibboleth.idp.cas.ticket.TicketService;
import net.shibboleth.idp.cas.ticket.TicketState;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.context.SessionContext;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.action.EventException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.config.SecurityConfiguration;
import org.slf4j.Logger;

public class GrantServiceTicketAction
extends AbstractCASProtocolAction<ServiceTicketRequest, ServiceTicketResponse> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(GrantServiceTicketAction.class);
    @Nonnull
    private final ConfigLookupFunction<LoginConfiguration> configLookupFunction;
    @Nonnull
    private final Function<ProfileRequestContext, SessionContext> sessionContextFunction;
    @Nonnull
    private final Function<ProfileRequestContext, AuthenticationContext> authnCtxLookupFunction;
    @Nonnull
    private final Function<ProfileRequestContext, String> principalLookupFunction;
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextLookupStrategy;
    @Nonnull
    private final TicketService casTicketService;
    @NonnullBeforeExec
    private LoginConfiguration loginConfig;
    @NonnullBeforeExec
    private SecurityConfiguration securityConfig;
    @NonnullBeforeExec
    private AuthenticationResult authnResult;
    private boolean storeConsent;
    @Nullable
    private AttributeContext attributeCtx;
    @NonnullBeforeExec
    private ServiceTicketRequest request;

    public GrantServiceTicketAction(@Nonnull TicketService ticketService) {
        this.casTicketService = (TicketService)Constraint.isNotNull((Object)ticketService, (String)"TicketService cannot be null");
        this.configLookupFunction = new ConfigLookupFunction(LoginConfiguration.class);
        this.sessionContextFunction = new ChildContextLookup(SessionContext.class);
        this.authnCtxLookupFunction = new ChildContextLookup(AuthenticationContext.class);
        Function plf = new SubjectContextPrincipalLookupFunction().compose((Function)new ChildContextLookup(SubjectContext.class));
        Function aclf = new ChildContextLookup(AttributeContext.class).compose((Function)new ChildContextLookup(RelyingPartyContext.class));
        assert (plf != null && aclf != null);
        this.principalLookupFunction = plf;
        this.attributeContextLookupStrategy = aclf;
    }

    public void setAttributeContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        this.checkSetterPreconditions();
        this.attributeContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        AttributeContext aCtx;
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.loginConfig = (LoginConfiguration)this.configLookupFunction.apply(profileRequestContext);
        LoginConfiguration lCfg = this.loginConfig;
        if (lCfg == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        this.securityConfig = lCfg.getSecurityConfiguration(profileRequestContext);
        if (this.securityConfig == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSecurityConfiguration");
            return false;
        }
        try {
            this.request = (ServiceTicketRequest)this.getCASRequest(profileRequestContext);
        }
        catch (EventException e) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)e.getEventID());
            return false;
        }
        AuthenticationContext authnCtx = this.authnCtxLookupFunction.apply(profileRequestContext);
        this.authnResult = authnCtx != null ? authnCtx.getAuthenticationResult() : this.getLatestAuthenticationResult(profileRequestContext);
        if (this.authnResult == null) {
            this.log.warn("{} No AuthenticationResult found", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return false;
        }
        if (lCfg.getPostAuthenticationFlows(profileRequestContext).contains("attribute-release") && (aCtx = (this.attributeCtx = this.attributeContextLookupStrategy.apply(profileRequestContext))) != null) {
            boolean bl = this.storeConsent = aCtx.isConsented() || lCfg.isStoreConsentInTickets(profileRequestContext);
            if (this.storeConsent) {
                this.log.debug("{} Storing consented attribute IDs into ticket: {}", (Object)this.getLogPrefix(), aCtx.getIdPAttributes().keySet());
            }
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ServiceTicket ticket;
        try {
            this.log.debug("{} Granting service ticket for {}", (Object)this.getLogPrefix(), (Object)this.request.getService());
            IdPSession session = this.getIdPSession(profileRequestContext);
            TicketState state = new TicketState(session != null ? session.getId() : null, this.getPrincipalName(profileRequestContext), this.authnResult.getAuthenticationInstant(), this.authnResult.getAuthenticationFlowId());
            if (this.storeConsent) {
                assert (this.attributeCtx != null);
                state.setConsentedAttributeIds(this.attributeCtx.getIdPAttributes().keySet());
            }
            Instant then = Instant.now().plus(this.loginConfig.getTicketValidityPeriod(profileRequestContext));
            assert (then != null);
            ticket = this.casTicketService.createServiceTicket(this.securityConfig.getIdGenerator().generateIdentifier(), then, this.request.getService(), state, this.request.isRenew());
        }
        catch (RuntimeException e) {
            this.log.error("{} Failed granting service ticket due to error.", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (Object)ProtocolError.TicketCreationError.event((Object)this));
            return;
        }
        ServiceTicketResponse response = new ServiceTicketResponse(this.request.getService(), ticket.getId());
        if (this.request.isSAML()) {
            response.setSaml(true);
        }
        try {
            this.setCASTicket(profileRequestContext, (Ticket)ticket);
            this.setCASResponse(profileRequestContext, response);
        }
        catch (EventException e) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)e.getEventID());
            return;
        }
        this.log.info("{} Granted service ticket for {}", (Object)this.getLogPrefix(), (Object)this.request.getService());
    }

    @Nullable
    private IdPSession getIdPSession(@Nonnull ProfileRequestContext prc) {
        SessionContext sessionContext = this.sessionContextFunction.apply(prc);
        return sessionContext != null ? sessionContext.getIdPSession() : null;
    }

    @Nonnull
    private String getPrincipalName(@Nonnull ProfileRequestContext prc) {
        String principal = this.principalLookupFunction.apply(prc);
        if (principal == null) {
            throw new IllegalStateException("Cannot determine IdP subject principal name.");
        }
        return principal;
    }

    @Nullable
    private AuthenticationResult getLatestAuthenticationResult(ProfileRequestContext prc) {
        AuthenticationResult latest = null;
        IdPSession session = this.getIdPSession(prc);
        if (session != null) {
            for (AuthenticationResult result : session.getAuthenticationResults()) {
                if (latest != null && !result.getAuthenticationInstant().isAfter(latest.getAuthenticationInstant())) continue;
                latest = result;
            }
        }
        return latest;
    }
}

