/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.flow.impl.AbstractOutgoingSamlMessageAction;
import net.shibboleth.idp.cas.protocol.ProtocolError;
import net.shibboleth.idp.cas.protocol.TicketValidationRequest;
import net.shibboleth.idp.cas.protocol.TicketValidationResponse;
import net.shibboleth.idp.cas.ticket.Ticket;
import net.shibboleth.idp.cas.ticket.TicketState;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.profile.action.EventException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.Attribute;
import org.opensaml.saml.saml1.core.AttributeStatement;
import org.opensaml.saml.saml1.core.AttributeValue;
import org.opensaml.saml.saml1.core.Audience;
import org.opensaml.saml.saml1.core.AudienceRestrictionCondition;
import org.opensaml.saml.saml1.core.AuthenticationStatement;
import org.opensaml.saml.saml1.core.Conditions;
import org.opensaml.saml.saml1.core.ConfirmationMethod;
import org.opensaml.saml.saml1.core.NameIdentifier;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml1.core.Status;
import org.opensaml.saml.saml1.core.StatusCode;
import org.opensaml.saml.saml1.core.Subject;
import org.opensaml.saml.saml1.core.SubjectConfirmation;
import org.slf4j.Logger;

public class BuildSamlValidationSuccessMessageAction
extends AbstractOutgoingSamlMessageAction {
    @Nonnull
    private static final String NAMESPACE = "http://www.ja-sig.org/products/cas/";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BuildSamlValidationSuccessMessageAction.class);
    @Nonnull
    private final XMLObjectBuilder<XSString> attrValueBuilder;
    @Nonnull
    private final IdentifierGenerationStrategy identifierGenerationStrategy;
    @Nonnull
    private final String entityID;

    public BuildSamlValidationSuccessMessageAction(@Nonnull IdentifierGenerationStrategy strategy, @Nonnull @NotEmpty String id) {
        Constraint.isNotNull((Object)strategy, (String)"IdentifierGenerationStrategy cannot be null");
        this.identifierGenerationStrategy = strategy;
        this.entityID = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)id), (String)"EntityID cannot be null");
        this.attrValueBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(XSString.TYPE_NAME);
    }

    @Override
    @Nonnull
    protected Response buildSamlResponse(@Nonnull ProfileRequestContext profileRequestContext) throws EventException {
        Instant now = Instant.now();
        TicketValidationRequest request = (TicketValidationRequest)this.getCASRequest(profileRequestContext);
        TicketValidationResponse ticketResponse = (TicketValidationResponse)this.getCASResponse(profileRequestContext);
        Ticket ticket = this.getCASTicket(profileRequestContext);
        TicketState state = ticket.getTicketState();
        if (state == null) {
            String name = ProtocolError.IllegalState.name();
            assert (name != null);
            throw new EventException(name);
        }
        this.log.debug("Building SAML response for {} in IdP session {}", (Object)request.getService(), (Object)state.getSessionId());
        Response response = BuildSamlValidationSuccessMessageAction.newSAMLObject(Response.class, Response.DEFAULT_ELEMENT_NAME);
        response.setID(request.getTicket());
        response.setIssueInstant(now);
        Status status = BuildSamlValidationSuccessMessageAction.newSAMLObject(Status.class, Status.DEFAULT_ELEMENT_NAME);
        StatusCode code = BuildSamlValidationSuccessMessageAction.newSAMLObject(StatusCode.class, StatusCode.DEFAULT_ELEMENT_NAME);
        code.setValue(StatusCode.SUCCESS);
        status.setStatusCode(code);
        response.setStatus(status);
        Assertion assertion = BuildSamlValidationSuccessMessageAction.newSAMLObject(Assertion.class, Assertion.DEFAULT_ELEMENT_NAME);
        assertion.setID(this.identifierGenerationStrategy.generateIdentifier());
        assertion.setIssueInstant(now);
        assertion.setVersion(SAMLVersion.VERSION_11);
        assertion.setIssuer(this.entityID);
        Conditions conditions = BuildSamlValidationSuccessMessageAction.newSAMLObject(Conditions.class, Conditions.DEFAULT_ELEMENT_NAME);
        conditions.setNotBefore(now);
        conditions.setNotOnOrAfter(now.plusSeconds(60L));
        AudienceRestrictionCondition audienceRestriction = BuildSamlValidationSuccessMessageAction.newSAMLObject(AudienceRestrictionCondition.class, AudienceRestrictionCondition.DEFAULT_ELEMENT_NAME);
        Audience audience = BuildSamlValidationSuccessMessageAction.newSAMLObject(Audience.class, Audience.DEFAULT_ELEMENT_NAME);
        audience.setURI(request.getService());
        audienceRestriction.getAudiences().add(audience);
        conditions.getAudienceRestrictionConditions().add(audienceRestriction);
        assertion.setConditions(conditions);
        assertion.getAuthenticationStatements().add(this.newAuthenticationStatement(now, state.getAuthenticationMethod(), state.getPrincipalName()));
        AttributeStatement attrStatement = BuildSamlValidationSuccessMessageAction.newSAMLObject(AttributeStatement.class, AttributeStatement.DEFAULT_ELEMENT_NAME);
        attrStatement.setSubject(this.newSubject(state.getPrincipalName()));
        for (net.shibboleth.idp.cas.attribute.Attribute casAttr : ticketResponse.getAttributes()) {
            Attribute attribute = BuildSamlValidationSuccessMessageAction.newSAMLObject(Attribute.class, Attribute.DEFAULT_ELEMENT_NAME);
            attribute.setAttributeName(casAttr.getName());
            attribute.setAttributeNamespace(NAMESPACE);
            for (String value : casAttr.getValues()) {
                attribute.getAttributeValues().add(this.newAttributeValue(value));
            }
            attrStatement.getAttributes().add(attribute);
        }
        assertion.getAttributeStatements().add(attrStatement);
        response.getAssertions().add(assertion);
        return response;
    }

    @Nonnull
    private Subject newSubject(@Nullable String identifier) {
        SubjectConfirmation confirmation = BuildSamlValidationSuccessMessageAction.newSAMLObject(SubjectConfirmation.class, SubjectConfirmation.DEFAULT_ELEMENT_NAME);
        ConfirmationMethod method = BuildSamlValidationSuccessMessageAction.newSAMLObject(ConfirmationMethod.class, ConfirmationMethod.DEFAULT_ELEMENT_NAME);
        method.setURI("urn:oasis:names:tc:SAML:1.0:cm:artifact");
        confirmation.getConfirmationMethods().add(method);
        NameIdentifier nameIdentifier = BuildSamlValidationSuccessMessageAction.newSAMLObject(NameIdentifier.class, NameIdentifier.DEFAULT_ELEMENT_NAME);
        nameIdentifier.setValue(identifier);
        Subject subject = BuildSamlValidationSuccessMessageAction.newSAMLObject(Subject.class, Subject.DEFAULT_ELEMENT_NAME);
        subject.setNameIdentifier(nameIdentifier);
        subject.setSubjectConfirmation(confirmation);
        return subject;
    }

    @Nonnull
    private AuthenticationStatement newAuthenticationStatement(@Nullable Instant authnInstant, @Nullable String authnMethod, @Nullable String principal) {
        AuthenticationStatement authnStatement = BuildSamlValidationSuccessMessageAction.newSAMLObject(AuthenticationStatement.class, AuthenticationStatement.DEFAULT_ELEMENT_NAME);
        authnStatement.setAuthenticationInstant(authnInstant);
        authnStatement.setAuthenticationMethod(authnMethod);
        authnStatement.setSubject(this.newSubject(principal));
        return authnStatement;
    }

    @Nonnull
    private XSString newAttributeValue(@Nullable String value) {
        XSString stringValue = (XSString)this.attrValueBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME);
        stringValue.setValue(value);
        return stringValue;
    }
}

