/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.protocol.ProtocolContext;
import net.shibboleth.idp.cas.service.Service;
import net.shibboleth.idp.cas.service.ServiceContext;
import net.shibboleth.idp.cas.ticket.Ticket;
import net.shibboleth.idp.cas.ticket.TicketContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.EventException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public abstract class AbstractCASProtocolAction<RequestType, ResponseType>
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractCASProtocolAction.class);
    @Nonnull
    private final Function<ProfileRequestContext, ProtocolContext<RequestType, ResponseType>> protocolLookupFunction = new ChildContextLookup(ProtocolContext.class, true);

    @Nonnull
    protected RequestType getCASRequest(@Nullable ProfileRequestContext prc) throws EventException {
        Object request = this.getProtocolContext(prc).getRequest();
        if (request == null) {
            this.log.error("{} CAS protocol request not found", (Object)this.getLogPrefix());
            throw new EventException("InvalidMessageContext");
        }
        return (RequestType)request;
    }

    protected void setCASRequest(@Nullable ProfileRequestContext prc, @Nonnull RequestType request) throws EventException {
        this.getProtocolContext(prc).setRequest(Constraint.isNotNull(request, (String)"CAS request cannot be null"));
    }

    @Nonnull
    protected ResponseType getCASResponse(@Nullable ProfileRequestContext prc) throws EventException {
        Object response = this.getProtocolContext(prc).getResponse();
        if (response == null) {
            this.log.error("{} CAS protocol response not found", (Object)this.getLogPrefix());
            throw new EventException("InvalidMessageContext");
        }
        return (ResponseType)response;
    }

    protected void setCASResponse(@Nullable ProfileRequestContext prc, @Nonnull ResponseType response) throws EventException {
        this.getProtocolContext(prc).setResponse(Constraint.isNotNull(response, (String)"CAS response cannot be null"));
    }

    @Nonnull
    protected Ticket getCASTicket(ProfileRequestContext prc) throws EventException {
        TicketContext context = (TicketContext)this.getProtocolContext(prc).getSubcontext(TicketContext.class);
        if (context == null || context.getTicket() == null) {
            this.log.error("{} CAS protocol ticket not found", (Object)this.getLogPrefix());
            throw new EventException("InvalidMessageContext");
        }
        return context.getTicket();
    }

    protected void setCASTicket(@Nullable ProfileRequestContext prc, @Nonnull Ticket ticket) throws EventException {
        this.getProtocolContext(prc).addSubcontext((BaseContext)new TicketContext((Ticket)Constraint.isNotNull((Object)ticket, (String)"CAS ticket cannot be null")));
    }

    @Nonnull
    protected Service getCASService(@Nullable ProfileRequestContext prc) throws EventException {
        ServiceContext context = (ServiceContext)this.getProtocolContext(prc).getSubcontext(ServiceContext.class);
        if (context == null || context.getService() == null) {
            this.log.error("{} CAS protocol service not found", (Object)this.getLogPrefix());
            throw new EventException("InvalidMessageContext");
        }
        return context.getService();
    }

    protected void setCASService(@Nullable ProfileRequestContext prc, @Nonnull Service service) throws EventException {
        this.getProtocolContext(prc).addSubcontext((BaseContext)new ServiceContext((Service)Constraint.isNotNull((Object)service, (String)"CAS service cannot be null")));
    }

    @Nonnull
    protected ProtocolContext<RequestType, ResponseType> getProtocolContext(@Nullable ProfileRequestContext prc) throws EventException {
        ProtocolContext<RequestType, ResponseType> casCtx = this.protocolLookupFunction.apply(prc);
        if (casCtx == null) {
            this.log.error("{} CAS ProtocolContext not found in ProfileRequestContext", (Object)this.getLogPrefix());
            throw new EventException("InvalidProfileContext");
        }
        return casCtx;
    }
}

