/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.installer.impl;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.Version;
import net.shibboleth.idp.installer.InstallerSupport;
import net.shibboleth.idp.installer.impl.BuildWar;
import net.shibboleth.idp.installer.impl.CopyDistribution;
import net.shibboleth.idp.installer.impl.CurrentInstallState;
import net.shibboleth.idp.installer.impl.IdPInstallerArguments;
import net.shibboleth.idp.installer.impl.InstallerPropertiesImpl;
import net.shibboleth.idp.installer.impl.V5Install;
import net.shibboleth.shared.cli.AbstractCommandLine;
import net.shibboleth.shared.cli.CommandLineArguments;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.tools.ant.BuildException;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.slf4j.Logger;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class IdPInstallerCLI
extends AbstractCommandLine<IdPInstallerArguments> {
    @Nullable
    private Logger log;

    @Nonnull
    protected Class<IdPInstallerArguments> getArgumentClass() {
        return IdPInstallerArguments.class;
    }

    @Nonnull
    protected String getVersion() {
        String result = Version.getVersion();
        assert (result != null);
        return result;
    }

    @Nonnull
    protected Logger getLogger() {
        Logger localLog = this.log;
        if (localLog == null) {
            localLog = this.log = LoggerFactory.getLogger(IdPInstallerCLI.class);
        }
        return localLog;
    }

    @Nonnull
    protected List<Resource> getAdditionalSpringResources() {
        return CollectionSupport.singletonList((Object)new ClassPathResource("net/shibboleth/idp/conf/http-client.xml"));
    }

    protected int doRun(@Nonnull IdPInstallerArguments args) {
        HttpClient httpClient;
        super.doRun((CommandLineArguments)args);
        Path source = InstallerSupport.pathOf((String)Constraint.isNotNull((Object)args.getSourceDir(), (String)"Source dir mist be specified"));
        assert (source != null);
        if (!Files.exists(source, new LinkOption[0])) {
            this.getLogger().error("Could not find {}", (Object)source);
            return 1;
        }
        String clientName = args.getHttpClientName();
        if (clientName == null) {
            clientName = "shibboleth.InternalHttpClient";
        }
        try {
            httpClient = (HttpClient)this.getApplicationContext().getBean(clientName, HttpClient.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            this.getLogger().error("Could not locate HttpClient '{}'", (Object)args.getHttpClientName());
            return 2;
        }
        String securityParametersName = args.getHttpClientSecurityParametersName();
        HttpClientSecurityParameters clientSecurityParameters = null;
        if (securityParametersName != null) {
            try {
                clientSecurityParameters = (HttpClientSecurityParameters)this.getApplicationContext().getBean(securityParametersName, HttpClientSecurityParameters.class);
            }
            catch (NoSuchBeanDefinitionException e) {
                this.getLogger().error("Could not locate HttpClientSecurityParameters '{}'", (Object)args.getHttpClientSecurityParametersName());
                return 2;
            }
        }
        if (args.isUnattended()) {
            System.setProperty("idp.noprompt", "true");
        }
        this.setIfNotNull(args.getPropertyFile(), "idp.property.file");
        this.setIfNotNull(args.getTargetDirectory(), "idp.target.dir");
        this.setIfNotNull(args.getHostName(), "idp.host.name");
        this.setIfNotNull(args.getScope(), "idp.scope");
        this.setIfNotNull(args.getEntityID(), "idp.entityID");
        this.setIfNotNull(args.getKeystorePassword(), "idp.keystore.password");
        this.setIfNotNull(args.getSealerPassword(), "idp.sealer.password");
        try {
            InstallerPropertiesImpl ip = new InstallerPropertiesImpl(source);
            ip.doInitialize();
            CurrentInstallState ic = new CurrentInstallState(ip);
            ic.initialize();
            CopyDistribution cd = new CopyDistribution(ip);
            cd.execute();
            V5Install install = new V5Install(ip, ic, httpClient, clientSecurityParameters);
            install.execute();
            BuildWar bw = new BuildWar(ip.getTargetDir());
            bw.execute();
        }
        catch (ComponentInitializationException e) {
            this.getLogger().error("Installation setup failed", (Throwable)e);
            return 2;
        }
        catch (BuildException e) {
            this.getLogger().error("Installation run failed", (Throwable)e);
            return 2;
        }
        return 0;
    }

    private void setIfNotNull(@Nullable String value, @Nonnull String propertyName) {
        if (value == null) {
            return;
        }
        System.setProperty(propertyName, value);
    }

    public static int runMain(@Nonnull String[] args) {
        IdPInstallerCLI cli = new IdPInstallerCLI();
        return cli.run(args);
    }

    public static void main(@Nonnull String[] args) {
        System.exit(IdPInstallerCLI.runMain(args));
    }
}

