/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.installer.impl;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.Version;
import net.shibboleth.idp.installer.InstallerSupport;
import net.shibboleth.idp.installer.impl.BuildWar;
import net.shibboleth.idp.installer.impl.IdPBuildArguments;
import net.shibboleth.shared.cli.AbstractCommandLine;
import net.shibboleth.shared.cli.CommandLineArguments;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class IdPBuildWar
extends AbstractCommandLine<IdPBuildArguments> {
    @Nullable
    private Logger log;

    @Nonnull
    protected Class<IdPBuildArguments> getArgumentClass() {
        return IdPBuildArguments.class;
    }

    @Nonnull
    protected String getVersion() {
        String result = Version.getVersion();
        assert (result != null);
        return result;
    }

    @Nonnull
    protected Logger getLogger() {
        Logger localLog = this.log;
        if (localLog == null) {
            localLog = this.log = LoggerFactory.getLogger(IdPBuildWar.class);
        }
        return localLog;
    }

    protected int doRun(@Nonnull IdPBuildArguments args) {
        super.doRun((CommandLineArguments)args);
        this.getLogger().debug("{}", (Object)args);
        this.getLogger().info("{}", (Object)args);
        String idpHomeString = args.getIdPHome();
        if (idpHomeString == null) {
            this.getLogger().error("--home must be specified");
            return 1;
        }
        Path idpHome = InstallerSupport.pathOf(idpHomeString);
        if (!Files.exists(idpHome, new LinkOption[0])) {
            this.getLogger().error("Could not find {}", (Object)idpHome);
            return 1;
        }
        BuildWar build = new BuildWar(idpHome);
        build.execute();
        return 0;
    }

    public static int runMain(@Nonnull String[] args) {
        IdPBuildWar cli = new IdPBuildWar();
        return cli.run(args);
    }

    public static void main(@Nonnull String[] args) {
        System.exit(IdPBuildWar.runMain(args));
    }
}

