/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.policyrule.saml.impl;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.filter.PolicyRequirementRule;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.attribute.filter.policyrule.impl.AbstractPolicyRule;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.ext.saml2mdrpi.RegistrationInfo;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.slf4j.Logger;

public abstract class AbstractRegistrationAuthorityPolicyRule
extends AbstractPolicyRule {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractRegistrationAuthorityPolicyRule.class);
    @Nonnull
    private Set<String> registrars = CollectionSupport.emptySet();
    private boolean matchIfMetadataSilent;

    @Nonnull
    @Unmodifiable
    @NotLive
    public Set<String> getRegistrars() {
        return CollectionSupport.copyToSet(this.registrars);
    }

    public void setRegistrars(@Nonnull Collection<String> theIssuers) {
        Constraint.isNotNull(theIssuers, (String)"Registrar collection cannot be null");
        this.registrars = new LinkedHashSet<String>(theIssuers.size());
        for (String s : theIssuers) {
            String trimmed = StringSupport.trimOrNull((String)s);
            if (trimmed == null) continue;
            this.registrars.add(trimmed);
        }
    }

    public boolean isMatchIfMetadataSilent() {
        return this.matchIfMetadataSilent;
    }

    public void setMatchIfMetadataSilent(boolean value) {
        this.matchIfMetadataSilent = value;
    }

    @Nullable
    protected abstract EntityDescriptor getEntityMetadata(@Nonnull AttributeFilterContext var1);

    @Nullable
    private RegistrationInfo getRegistrationInfo(@Nonnull AttributeFilterContext filterContext) {
        EntityDescriptor spEntity = this.getEntityMetadata(filterContext);
        if (null == spEntity) {
            this.log.debug("{} Filtering on registration, but no peer metadata available", (Object)this.getLogPrefix());
            return null;
        }
        Extensions extensions = spEntity.getExtensions();
        if (null != extensions) {
            for (XMLObject object : extensions.getUnknownXMLObjects(RegistrationInfo.DEFAULT_ELEMENT_NAME)) {
                if (!(object instanceof RegistrationInfo)) continue;
                return (RegistrationInfo)object;
            }
        }
        for (EntitiesDescriptor group = (EntitiesDescriptor)spEntity.getParent(); null != group; group = (EntitiesDescriptor)group.getParent()) {
            extensions = group.getExtensions();
            if (null == extensions) continue;
            for (XMLObject object : extensions.getUnknownXMLObjects(RegistrationInfo.DEFAULT_ELEMENT_NAME)) {
                if (!(object instanceof RegistrationInfo)) continue;
                return (RegistrationInfo)object;
            }
        }
        this.log.debug("{} Filtering on registration, but no RegistrationInfo available", (Object)this.getLogPrefix());
        return null;
    }

    @Nonnull
    public PolicyRequirementRule.Tristate matches(@Nonnull AttributeFilterContext filterContext) {
        RegistrationInfo info = this.getRegistrationInfo(filterContext);
        if (info == null) {
            this.log.debug("{} The peer's metadata did not contain a RegistrationInfo descriptor", (Object)this.getLogPrefix());
            if (this.matchIfMetadataSilent) {
                return PolicyRequirementRule.Tristate.TRUE;
            }
            return PolicyRequirementRule.Tristate.FALSE;
        }
        String authority = info.getRegistrationAuthority();
        this.log.debug("{} Peer's metadata has registration authority: {}", (Object)this.getLogPrefix(), (Object)authority);
        if (this.registrars.contains(authority)) {
            this.log.debug("{} Peer's metadata registration authority matches", (Object)this.getLogPrefix());
            return PolicyRequirementRule.Tristate.TRUE;
        }
        this.log.debug("{} Peer's metadata registration authority does not match", (Object)this.getLogPrefix());
        return PolicyRequirementRule.Tristate.FALSE;
    }
}

