/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.policyrule.saml.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.filter.PolicyRequirementRule;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.attribute.filter.policyrule.impl.AbstractPolicyRule;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.slf4j.Logger;

public abstract class AbstractProtocolSupportPolicyRule
extends AbstractPolicyRule {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractProtocolSupportPolicyRule.class);
    @NonnullAfterInit
    private String protocol;

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.protocol == null) {
            this.log.error("{} protocol not set", (Object)this.getLogPrefix());
            throw new ComponentInitializationException("Protocol not set in ProtocolSupportPolicyRule");
        }
    }

    @Nonnull
    public String getProtocol() {
        assert (this.protocol != null);
        return this.protocol;
    }

    public void setProtocol(@Nonnull String what) {
        this.protocol = (String)Constraint.isNotNull((Object)what, (String)"Supplier protocol was null");
    }

    @Nonnull
    public PolicyRequirementRule.Tristate matches(@Nonnull AttributeFilterContext filterContext) {
        RoleDescriptor role = this.getRoleDescriptor(filterContext);
        if (role == null) {
            return PolicyRequirementRule.Tristate.FAIL;
        }
        if (role.getSupportedProtocols().contains(this.protocol)) {
            return PolicyRequirementRule.Tristate.TRUE;
        }
        return PolicyRequirementRule.Tristate.FALSE;
    }

    @Nullable
    protected abstract RoleDescriptor getRoleDescriptor(@Nonnull AttributeFilterContext var1);
}

