/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.policyrule.logic.impl;

import com.google.common.base.MoreObjects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.filter.PolicyRequirementRule;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;

@ThreadSafe
public final class NotPolicyRule
extends AbstractIdentifiableInitializableComponent
implements PolicyRequirementRule {
    @NonnullAfterInit
    private PolicyRequirementRule negatedRule;

    public void setNegation(@Nonnull PolicyRequirementRule rule) {
        this.negatedRule = (PolicyRequirementRule)Constraint.isNotNull((Object)rule, (String)"Policy Requirement rule can not be null");
    }

    @Nonnull
    public PolicyRequirementRule getNegatedRule() {
        assert (this.negatedRule != null);
        return this.negatedRule;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.negatedRule) {
            throw new ComponentInitializationException("Rule to negate not set up");
        }
    }

    @Nonnull
    public PolicyRequirementRule.Tristate matches(@Nonnull AttributeFilterContext filterContext) {
        Constraint.isNotNull((Object)filterContext, (String)"Attribute filter context can not be null");
        this.checkComponentActive();
        PolicyRequirementRule.Tristate match = this.negatedRule.matches(filterContext);
        if (PolicyRequirementRule.Tristate.FAIL == match) {
            return PolicyRequirementRule.Tristate.FAIL;
        }
        if (PolicyRequirementRule.Tristate.FALSE == match) {
            return PolicyRequirementRule.Tristate.TRUE;
        }
        return PolicyRequirementRule.Tristate.FALSE;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("Negated Policy Rule", (Object)this.negatedRule).toString();
    }
}

