/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.policyrule.impl;

import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.script.ScriptContext;
import net.shibboleth.idp.attribute.filter.FilterScriptContextExtender;
import net.shibboleth.idp.attribute.filter.PolicyRequirementRule;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.component.UnmodifiableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.scripting.AbstractScriptEvaluator;
import net.shibboleth.shared.scripting.EvaluableScript;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

@ThreadSafe
public class ScriptedPolicyRule
extends AbstractIdentifiableInitializableComponent
implements PolicyRequirementRule,
UnmodifiableComponent {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScriptedPolicyRule.class);
    @NonnullAfterInit
    private EvaluableScript script;
    @NonnullAfterInit
    private PolicyRuleScriptEvaluator scriptEvaluator;
    @Nonnull
    private Collection<FilterScriptContextExtender> contextExtenders = CollectionSupport.emptyList();
    @Nullable
    private Object customObject;

    @Nullable
    public Object getCustomObject() {
        return this.customObject;
    }

    public void setCustomObject(@Nullable Object object) {
        this.checkSetterPreconditions();
        this.customObject = object;
    }

    @Nonnull
    private EvaluableScript getScript() {
        assert (this.script != null);
        return this.script;
    }

    public void setScript(@Nonnull EvaluableScript matcherScript) {
        this.checkSetterPreconditions();
        this.script = (EvaluableScript)Constraint.isNotNull((Object)matcherScript, (String)"Attribute value matching script can not be null");
    }

    public void setScriptContextExtenders(@Nullable Collection<FilterScriptContextExtender> extenders) {
        this.checkSetterPreconditions();
        this.contextExtenders = extenders != null ? CollectionSupport.copyToList(extenders) : CollectionSupport.emptyList();
    }

    @Nonnull
    public PolicyRequirementRule.Tristate matches(@Nonnull AttributeFilterContext filterContext) {
        Constraint.isNotNull((Object)filterContext, (String)"Attribute filter context cannot be null");
        this.checkComponentActive();
        return this.scriptEvaluator.execute(filterContext);
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.script) {
            throw new ComponentInitializationException("No script has been provided");
        }
        this.scriptEvaluator = new PolicyRuleScriptEvaluator(this.getScript());
        this.scriptEvaluator.setCustomObject(this.customObject);
        this.scriptEvaluator.setContextExtenders(this.contextExtenders);
        StringBuilder builder = new StringBuilder("Scripted Attribute Filter '").append(this.getId()).append("':");
        this.scriptEvaluator.setLogPrefix(builder.toString());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ScriptedPolicyRule)) {
            return false;
        }
        ScriptedPolicyRule other = (ScriptedPolicyRule)((Object)obj);
        return other.getScript().equals(this.script);
    }

    public int hashCode() {
        return Objects.hash(this.script, this.getId());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("Script", (Object)this.getScript()).toString();
    }

    private class PolicyRuleScriptEvaluator
    extends AbstractScriptEvaluator {
        public PolicyRuleScriptEvaluator(EvaluableScript theScript) {
            super(theScript);
            this.setOutputType(Boolean.class);
            this.setReturnOnError(PolicyRequirementRule.Tristate.FAIL);
            this.setHideExceptions(true);
        }

        @Nonnull
        public PolicyRequirementRule.Tristate execute(@Nonnull AttributeFilterContext filterContext) {
            Object result = this.evaluate(new Object[]{filterContext});
            if (null == result) {
                ScriptedPolicyRule.this.log.error("{} Matcher script did not return a result", (Object)this.getLogPrefix());
                return PolicyRequirementRule.Tristate.FAIL;
            }
            if (result instanceof Boolean) {
                return (Boolean)result != false ? PolicyRequirementRule.Tristate.TRUE : PolicyRequirementRule.Tristate.FALSE;
            }
            return (PolicyRequirementRule.Tristate)result;
        }

        protected void prepareContext(@Nonnull ScriptContext scriptContext, Object ... input) {
            if (input != null) {
                scriptContext.setAttribute("filterContext", input[0], 100);
                ProfileRequestContext prc = (ProfileRequestContext)((AttributeFilterContext)input[0]).getProfileRequestContextLookupStrategy().apply((AttributeFilterContext)input[0]);
                scriptContext.setAttribute("profileContext", prc, 100);
            } else {
                ScriptedPolicyRule.this.log.error("{} Script invoked with null inputs", (Object)this.getLogPrefix());
            }
        }
    }
}

