/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.ext.saml2aslo.Asynchronous;
import org.opensaml.saml.saml2.core.Extensions;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SSODescriptor;
import org.slf4j.Logger;

public class PreProcessLogoutMessage
extends AbstractProfileAction {
    @Nonnull
    public static final String IS_LOGOUT_RESPONSE = "IsLogoutResponse";
    @Nonnull
    public static final String IS_LOGOUT_REQUEST_ASYNC = "IsLogoutRequestAsync";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PreProcessLogoutMessage.class);
    private boolean assumeAsync;
    @Nonnull
    private Function<ProfileRequestContext, SAMLMetadataContext> metadataContextLookupStrategy;

    public PreProcessLogoutMessage() {
        Function mcls = new InboundMessageContextLookup().andThen(new ChildContextLookup(SAMLPeerEntityContext.class).andThen((Function)new ChildContextLookup(SAMLMetadataContext.class)));
        assert (mcls != null);
        this.metadataContextLookupStrategy = mcls;
    }

    public void setAssumeAsynchronousLogout(boolean flag) {
        this.checkSetterPreconditions();
        this.assumeAsync = flag;
    }

    public void setMetadataContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLMetadataContext> strategy) {
        this.checkSetterPreconditions();
        this.metadataContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLMetadataContext lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        MessageContext imc = profileRequestContext.getInboundMessageContext();
        if (imc == null) {
            this.log.warn("{} No inbound message context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        if (!(imc.getMessage() instanceof SAMLObject)) {
            this.log.warn("{} No inbound SAML message", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        MessageContext imc = profileRequestContext.getInboundMessageContext();
        assert (imc != null);
        SAMLObject msg = (SAMLObject)imc.getMessage();
        if (msg instanceof LogoutResponse) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)IS_LOGOUT_RESPONSE);
            return;
        }
        if (!(msg instanceof LogoutRequest)) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        Extensions exts = ((LogoutRequest)msg).getExtensions();
        if (exts != null && !exts.getUnknownXMLObjects(Asynchronous.DEFAULT_ELEMENT_NAME).isEmpty()) {
            this.log.debug("{} LogoutRequest contained Asynchronous extension", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)IS_LOGOUT_REQUEST_ASYNC);
            return;
        }
        if (this.assumeAsync) {
            RoleDescriptor roleDescriptor;
            SAMLMetadataContext mdCtx = this.metadataContextLookupStrategy.apply(profileRequestContext);
            RoleDescriptor roleDescriptor2 = roleDescriptor = mdCtx == null ? null : mdCtx.getRoleDescriptor();
            if (roleDescriptor == null || !(roleDescriptor instanceof SSODescriptor) || ((SSODescriptor)roleDescriptor).getSingleLogoutServices().isEmpty()) {
                this.log.debug("{} LogoutRequest treated as Asynchronous due to lack of metadata", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)IS_LOGOUT_REQUEST_ASYNC);
            }
        }
    }
}

