/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.MessageLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.slf4j.Logger;

public class EnforceDisallowedSSOFeatures
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(EnforceDisallowedSSOFeatures.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @Nonnull
    private Function<ProfileRequestContext, AuthnRequest> authnRequestLookupStrategy;
    @NonnullBeforeExec
    private AuthnRequest authnRequest;

    public EnforceDisallowedSSOFeatures() {
        Function arls = new MessageLookup(AuthnRequest.class).compose((Function)new InboundMessageContextLookup());
        assert (arls != null);
        this.authnRequestLookupStrategy = arls;
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.checkSetterPreconditions();
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setAuthnRequestLookupStrategy(@Nonnull Function<ProfileRequestContext, AuthnRequest> strategy) {
        this.checkSetterPreconditions();
        this.authnRequestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AuthnRequest lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.checkComponentActive();
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.authnRequest = this.authnRequestLookupStrategy.apply(profileRequestContext);
        if (this.authnRequest == null) {
            this.log.debug("{} AuthnRequest message was not returned by lookup strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ProfileConfiguration pc;
        RelyingPartyContext rpContext = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        ProfileConfiguration profileConfiguration = pc = rpContext == null ? null : rpContext.getProfileConfig();
        if (rpContext == null || pc == null || !(pc instanceof BrowserSSOProfileConfiguration)) {
            this.log.debug("{} No BrowserSSOProfileConfiguration available, skipping feature enforcement", (Object)this.getLogPrefix());
            return;
        }
        BrowserSSOProfileConfiguration profileConfiguration2 = (BrowserSSOProfileConfiguration)pc;
        Boolean forceAuthn = this.authnRequest.isForceAuthn();
        if (forceAuthn != null && forceAuthn.booleanValue() && profileConfiguration2.isFeatureDisallowed(profileRequestContext, 16)) {
            this.log.warn("{} Use of ForceAuthn disallowed by profile configuration", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"AccessDenied");
            return;
        }
        NameIDPolicy nidPolicy = this.authnRequest.getNameIDPolicy();
        if (nidPolicy != null) {
            if (nidPolicy.getFormat() != null && profileConfiguration2.isFeatureDisallowed(profileRequestContext, 4) && !"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified".equals(nidPolicy.getFormat()) && !"urn:oasis:names:tc:SAML:2.0:nameid-format:encrypted".equals(nidPolicy.getFormat())) {
                this.log.warn("{} Incoming NameID Format disallowed by profile configuration", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"AccessDenied");
                return;
            }
            if (nidPolicy.getSPNameQualifier() != null && profileConfiguration2.isFeatureDisallowed(profileRequestContext, 8)) {
                this.log.warn("{} Incoming SPNameQualifier disallowed by profile configuration", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"AccessDenied");
                return;
            }
        }
    }
}

