/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.config.impl;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.profile.config.impl.AbstractSAMLProfileConfiguration;
import net.shibboleth.saml.saml2.profile.config.SAML2ProfileConfiguration;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public abstract class AbstractSAML2ProfileConfiguration
extends AbstractSAMLProfileConfiguration
implements SAML2ProfileConfiguration {
    @Nonnull
    private Predicate<ProfileRequestContext> ignoreRequestSignaturesPredicate = PredicateSupport.alwaysFalse();
    @Nonnull
    private Predicate<ProfileRequestContext> encryptionOptionalPredicate = PredicateSupport.alwaysFalse();
    @Nonnull
    private Predicate<ProfileRequestContext> encryptNameIDsPredicate = PredicateSupport.alwaysFalse();

    public AbstractSAML2ProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
    }

    public boolean isIgnoreRequestSignatures(@Nullable ProfileRequestContext profileRequestContext) {
        return this.ignoreRequestSignaturesPredicate.test(profileRequestContext);
    }

    public void setIgnoreRequestSignatures(boolean flag) {
        this.ignoreRequestSignaturesPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setIgnoreRequestSignaturesPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.ignoreRequestSignaturesPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    public boolean isEncryptionOptional(@Nullable ProfileRequestContext profileRequestContext) {
        return this.encryptionOptionalPredicate.test(profileRequestContext);
    }

    public void setEncryptionOptional(boolean flag) {
        this.encryptionOptionalPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setEncryptionOptionalPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.encryptionOptionalPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Encryption optional predicate cannot be null");
    }

    public boolean isEncryptNameIDs(@Nullable ProfileRequestContext profileRequestContext) {
        return this.encryptNameIDsPredicate.test(profileRequestContext);
    }

    public void setEncryptNameIDs(boolean flag) {
        this.encryptNameIDsPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setEncryptNameIDsPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.encryptNameIDsPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Condition cannot be null");
    }
}

