/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.saml.authn.principal.NameIdentifierPrincipal;
import net.shibboleth.idp.saml.nameid.AbstractNameIDCanonicalizer;
import net.shibboleth.idp.saml.nameid.NameDecoderException;
import net.shibboleth.idp.saml.nameid.NameIdentifierDecoder;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.saml.saml1.profile.SAML1ObjectSupport;
import org.slf4j.Logger;

public class NameIdentifierCanonicalization
extends AbstractNameIDCanonicalizer {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(NameIdentifierCanonicalization.class);
    @NonnullAfterInit
    private NameIdentifierDecoder decoder;

    @NonnullAfterInit
    public NameIdentifierDecoder getDecoder() {
        return this.decoder;
    }

    public void setDecoder(@Nonnull NameIdentifierDecoder theDecoder) {
        this.checkSetterPreconditions();
        this.decoder = (NameIdentifierDecoder)Constraint.isNotNull((Object)theDecoder, (String)"NameIdentifierDecoder cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.decoder) {
            throw new ComponentInitializationException(this.getLogPrefix() + " decoder not supplied");
        }
    }

    @Nullable
    protected String doApply(@Nonnull SubjectCanonicalizationContext c14nContext) {
        NameIdentifierPrincipal prin = this.getNameIdentifierPrincipal(c14nContext);
        if (prin == null) {
            return null;
        }
        try {
            c14nContext.setPrincipalName(this.decoder.decode(c14nContext, prin.getNameIdentifier()));
            if (c14nContext.getPrincipalName() == null) {
                return "InvalidSubject";
            }
            return "proceed";
        }
        catch (NameDecoderException e) {
            c14nContext.setException((Exception)((Object)e));
            return "SubjectCanonicalizationError";
        }
    }

    @Nullable
    private NameIdentifierPrincipal getNameIdentifierPrincipal(@Nonnull SubjectCanonicalizationContext c14nContext) {
        if (c14nContext.getSubject() != null) {
            Subject subject = c14nContext.getSubject();
            assert (subject != null);
            Set<NameIdentifierPrincipal> nameIDs = subject.getPrincipals(NameIdentifierPrincipal.class);
            if (nameIDs == null || nameIDs.isEmpty()) {
                this.log.debug("{} No NameIdentifierPrincipals were found", (Object)this.getLogPrefix());
                return null;
            }
            if (nameIDs.size() > 1) {
                this.log.debug("{} Multiple NameIdentifierPrincipals were found", (Object)this.getLogPrefix());
                return null;
            }
            NameIdentifierPrincipal prin = nameIDs.iterator().next();
            String format = prin.getNameIdentifier().getFormat();
            if (format == null) {
                format = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
            }
            if (this.formatMatches(c14nContext, format)) {
                return prin;
            }
            this.log.debug("{} Format not supported", (Object)this.getLogPrefix());
        }
        return null;
    }

    private boolean formatMatches(@Nonnull SubjectCanonicalizationContext c14nContext, @Nonnull String format) {
        for (String testFormat : this.getFormats()) {
            if (!SAML1ObjectSupport.areNameIdentifierFormatsEquivalent((String)testFormat, (String)format)) continue;
            this.log.debug("{} Format matches {}", (Object)this.getLogPrefix(), (Object)testFormat);
            return true;
        }
        this.log.debug("{} No format matches", (Object)this.getLogPrefix());
        return false;
    }
}

