/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.saml.authn.principal.NameIDPrincipal;
import net.shibboleth.idp.saml.nameid.AbstractNameIDCanonicalizer;
import net.shibboleth.idp.saml.nameid.NameDecoderException;
import net.shibboleth.idp.saml.nameid.NameIDDecoder;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.saml.saml2.profile.SAML2ObjectSupport;
import org.slf4j.Logger;

public class NameIDCanonicalization
extends AbstractNameIDCanonicalizer {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(NameIDCanonicalization.class);
    @NonnullAfterInit
    private NameIDDecoder decoder;

    @NonnullAfterInit
    public NameIDDecoder getDecoder() {
        return this.decoder;
    }

    public void setDecoder(@Nonnull NameIDDecoder theDecoder) {
        this.checkSetterPreconditions();
        this.decoder = (NameIDDecoder)Constraint.isNotNull((Object)theDecoder, (String)"Name ID decoder cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        if (null == this.decoder) {
            throw new ComponentInitializationException(this.getLogPrefix() + " decoder not supplied");
        }
        super.doInitialize();
    }

    @Nullable
    protected String doApply(@Nonnull SubjectCanonicalizationContext c14nContext) {
        NameIDPrincipal prin = this.getNameIDPrincipal(c14nContext);
        if (prin == null) {
            return null;
        }
        try {
            c14nContext.setPrincipalName(this.decoder.decode(c14nContext, prin.getNameID()));
            if (c14nContext.getPrincipalName() == null) {
                return "InvalidSubject";
            }
            return "proceed";
        }
        catch (NameDecoderException e) {
            c14nContext.setException((Exception)((Object)e));
            return "SubjectCanonicalizationError";
        }
    }

    @Nullable
    private NameIDPrincipal getNameIDPrincipal(@Nonnull SubjectCanonicalizationContext c14nContext) {
        if (c14nContext.getSubject() != null) {
            Subject subject = c14nContext.getSubject();
            assert (subject != null);
            Set<NameIDPrincipal> nameIDs = subject.getPrincipals(NameIDPrincipal.class);
            if (nameIDs == null || nameIDs.isEmpty()) {
                this.log.debug("{} No NameIDPrincipals were found", (Object)this.getLogPrefix());
                return null;
            }
            if (nameIDs.size() > 1) {
                this.log.debug("{} Multiple NameIDPrincipals were found", (Object)this.getLogPrefix());
                return null;
            }
            NameIDPrincipal prin = nameIDs.iterator().next();
            String format = prin.getNameID().getFormat();
            if (format == null) {
                format = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
            }
            if (this.formatMatches(c14nContext, format)) {
                return prin;
            }
            this.log.debug("{} Format not supported", (Object)this.getLogPrefix());
        }
        return null;
    }

    private boolean formatMatches(@Nonnull SubjectCanonicalizationContext c14nContext, @Nonnull String format) {
        this.log.debug("{} Attempting to match format '{}'", (Object)this.getLogPrefix(), (Object)format);
        for (String testFormat : this.getFormats()) {
            if (!SAML2ObjectSupport.areNameIDFormatsEquivalent((String)testFormat, (String)format)) continue;
            this.log.debug("{} Format matches {}", (Object)this.getLogPrefix(), (Object)testFormat);
            return true;
        }
        this.log.debug("{} No format matches", (Object)this.getLogPrefix());
        return false;
    }
}

