/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.audit.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.ArtifactResponse;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.SessionIndex;

public class SessionIndexAuditExtractor
implements Function<ProfileRequestContext, Collection<String>> {
    @Nonnull
    private final Function<ProfileRequestContext, SAMLObject> messageLookupStrategy;

    public SessionIndexAuditExtractor(@Nonnull Function<ProfileRequestContext, SAMLObject> strategy) {
        this.messageLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Message lookup strategy cannot be null");
    }

    @Override
    @Nullable
    @Unmodifiable
    @NotLive
    public Collection<String> apply(@Nullable ProfileRequestContext input) {
        SAMLObject message = this.messageLookupStrategy.apply(input);
        if (message != null) {
            ArrayList<String> indexes = new ArrayList<String>(1);
            if (message instanceof ArtifactResponse) {
                message = ((ArtifactResponse)message).getMessage();
            }
            if (message instanceof Response) {
                for (Assertion assertion : ((Response)message).getAssertions()) {
                    for (AuthnStatement statement : assertion.getAuthnStatements()) {
                        if (statement.getSessionIndex() == null) continue;
                        indexes.add(statement.getSessionIndex());
                    }
                }
            } else if (message instanceof LogoutRequest) {
                for (SessionIndex index : ((LogoutRequest)message).getSessionIndexes()) {
                    if (index == null || index.getValue() == null) continue;
                    indexes.add(index.getValue());
                }
            }
            return indexes;
        }
        return CollectionSupport.emptyList();
    }
}

