/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.audit.impl;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.audit.impl.AbstractProxyRestrictionAuditExtractor;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import org.opensaml.core.xml.schema.XSURI;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.ProxyRestriction;

public class ProxyAudienceAuditExtractor
extends AbstractProxyRestrictionAuditExtractor<Collection<String>> {
    public ProxyAudienceAuditExtractor(@Nonnull Function<ProfileRequestContext, SAMLObject> strategy) {
        super(strategy);
    }

    @Override
    @Nullable
    @Unmodifiable
    @NotLive
    protected Collection<String> doApply(@Nullable ProxyRestriction condition) {
        if (condition != null) {
            List audiences = condition.getAudiences();
            assert (audiences != null);
            return audiences.stream().map(XSURI::getURI).collect(Collectors.toUnmodifiableList());
        }
        return null;
    }
}

