/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cli;

import com.beust.jcommander.Parameter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cli.AbstractCommandLineArguments;

public class DumpConfigArguments
extends AbstractCommandLineArguments {
    @Parameter(names={"-r", "--requester"}, required=true, description="Relying party identity")
    @Nullable
    private String requester;
    @Parameter(names={"-P", "--profile"}, required=true, description="Profile identifier")
    @Nullable
    private String profile;
    @Parameter(names={"--protocol"}, description="Protocol support enumeration for metadata lookup")
    @Nullable
    private String protocol;
    @Parameter(names={"--saml1"}, description="Use SAML 1.1 protocol for metadata lookup")
    private boolean saml1;
    @Parameter(names={"--saml2"}, description="Use SAML 2.0 protocol for metadata lookup")
    private boolean saml2;
    @Parameter(names={"--cas"}, description="Use CAS protocol for metadata lookup")
    private boolean cas;
    @Parameter(names={"--oidc"}, description="Use OIDC protocol for metadata lookup")
    private boolean oidc;

    @Override
    public void validate() {
        String msg = "The saml1, saml2, cas, oidc, and protocol options are mutually exclusive";
        if (this.saml1 ? this.saml2 || this.cas || this.oidc || this.protocol != null : (this.saml2 ? this.saml1 || this.cas || this.oidc || this.protocol != null : (this.cas ? this.saml1 || this.saml2 || this.oidc || this.protocol != null : (this.oidc ? this.saml1 || this.saml2 || this.cas || this.protocol != null : this.protocol != null && (this.saml1 || this.saml2 || this.cas || this.oidc))))) {
            throw new IllegalArgumentException("The saml1, saml2, cas, oidc, and protocol options are mutually exclusive");
        }
    }

    @Override
    @Nonnull
    protected StringBuilder doBuildURL(@Nonnull StringBuilder builder) {
        if (this.getPath() == null) {
            builder.append("/profile/admin/dumpconfig");
        }
        if (builder.toString().contains("?")) {
            builder.append('&');
        } else {
            builder.append('?');
        }
        try {
            builder.append("requester=").append(URLEncoder.encode(this.requester, "UTF-8")).append("&profile=").append(URLEncoder.encode(this.profile, "UTF-8"));
            if (this.saml1) {
                builder.append("&saml1");
            } else if (this.saml2) {
                builder.append("&saml2");
            } else if (this.cas) {
                builder.append("&cas");
            } else if (this.oidc) {
                builder.append("&oidc");
            } else if (this.protocol != null) {
                builder.append("&protocol=").append(URLEncoder.encode(this.protocol, "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return builder;
    }
}

