/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cli;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.Version;
import net.shibboleth.idp.cli.AbstractIdPHomeAwareCommandLine;
import net.shibboleth.idp.cli.DataSealerArguments;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.DataSealer;
import org.slf4j.Logger;

public class DataSealerCLI
extends AbstractIdPHomeAwareCommandLine<DataSealerArguments> {
    @Nullable
    private Logger log;

    @Nonnull
    protected Logger getLogger() {
        if (this.log == null) {
            this.log = LoggerFactory.getLogger(DataSealerCLI.class);
        }
        assert (this.log != null);
        return this.log;
    }

    @Nonnull
    protected Class<DataSealerArguments> getArgumentClass() {
        return DataSealerArguments.class;
    }

    @Nonnull
    @NotEmpty
    protected String getVersion() {
        String result = Version.getVersion();
        assert (result != null);
        return result;
    }

    @Override
    protected int doRun(@Nonnull DataSealerArguments args) {
        int ret = super.doRun(args);
        if (ret != 0) {
            return ret;
        }
        try {
            String sealerName = args.getDataSealerName();
            DataSealer sealer = sealerName != null ? (DataSealer)this.getApplicationContext().getBean(sealerName, DataSealer.class) : (DataSealer)this.getApplicationContext().getBean(DataSealer.class);
            DataSealerArguments.OperationType op = args.getOperation();
            String arg2 = (String)args.getOtherArgs().get(2);
            assert (arg2 != null && op != null);
            switch (op) {
                case WRAP: {
                    System.out.println(sealer.wrap(arg2));
                    break;
                }
                case UNWRAP: {
                    System.out.println(sealer.unwrap(arg2));
                    break;
                }
                default: {
                    this.getLogger().error("Invalid operation");
                    return 2;
                }
            }
        }
        catch (Exception e) {
            if (args.isVerboseOutput()) {
                this.getLogger().error("Unable to access DataSealer from Spring context", (Throwable)e);
            } else {
                this.getLogger().error("Unable to access DataSealer from Spring context", (Object)e.getMessage());
            }
            return -1;
        }
        return 0;
    }

    public static void main(@Nonnull String[] args) {
        System.exit(new DataSealerCLI().run(args));
    }
}

