/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.url;

import java.util.Arrays;
import org.ldaptive.LdapUtils;
import org.ldaptive.SearchScope;
import org.ldaptive.dn.DefaultDnParser;
import org.ldaptive.dn.Dn;
import org.ldaptive.dn.DnParser;
import org.ldaptive.filter.DefaultFilterFunction;
import org.ldaptive.filter.Filter;
import org.ldaptive.filter.FilterFunction;
import org.ldaptive.filter.PresenceFilter;
import org.ldaptive.url.DefaultUrlParser;
import org.ldaptive.url.MinimalUrlFormatter;
import org.ldaptive.url.UrlFormatter;
import org.ldaptive.url.UrlParser;

public final class Url {
    static final int DEFAULT_LDAP_PORT = 389;
    static final int DEFAULT_LDAPS_PORT = 636;
    static final int DEFAULT_LDAPI_PORT = 0;
    static final String DEFAULT_BASE_DN = "";
    static final Dn DEFAULT_PARSED_BASE_DN = new Dn();
    static final String DEFAULT_FILTER = "(objectClass=*)";
    static final Filter DEFAULT_PARSED_FILTER = new PresenceFilter("objectClass");
    static final SearchScope DEFAULT_SCOPE = SearchScope.OBJECT;
    static final String[] DEFAULT_ATTRIBUTES = new String[0];
    private static final int HASH_CODE_SEED = 11003;
    private static final DnParser DN_PARSER = new DefaultDnParser();
    private static final FilterFunction FILTER_FUNCTION = new DefaultFilterFunction();
    private static final String LDAP_SCHEME = "ldap";
    private static final String LDAPS_SCHEME = "ldaps";
    private static final String LDAPI_SCHEME = "ldapi";
    private final String scheme;
    private final String hostname;
    private final int port;
    private final String baseDn;
    private final Dn parsedBaseDn;
    private final String[] attributes;
    private final SearchScope scope;
    private final String filter;
    private final Filter parsedFilter;

    private Url(Url ldapURL) {
        this.scheme = ldapURL.scheme;
        this.hostname = ldapURL.hostname;
        this.port = ldapURL.port;
        this.baseDn = ldapURL.baseDn;
        this.parsedBaseDn = ldapURL.parsedBaseDn;
        this.attributes = ldapURL.attributes;
        this.scope = ldapURL.scope;
        this.filter = ldapURL.filter;
        this.parsedFilter = ldapURL.parsedFilter;
    }

    Url(String scheme, String hostname, int port, String baseDn, String[] attributes, SearchScope scope, String filter) {
        Url.validateScheme(scheme);
        Url.validatePort(port, true);
        this.scheme = scheme;
        this.hostname = hostname;
        this.port = port;
        this.baseDn = baseDn;
        try {
            this.parsedBaseDn = this.baseDn != null ? new Dn(this.baseDn, DN_PARSER) : null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid baseDN: " + this.baseDn, e);
        }
        this.attributes = attributes;
        this.scope = scope;
        this.filter = filter;
        try {
            this.parsedFilter = this.filter != null ? FILTER_FUNCTION.parse(this.filter) : null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid filter: " + this.filter, e);
        }
    }

    public Url(String url) {
        this(url, new DefaultUrlParser());
    }

    public Url(String url, UrlParser parser) {
        this(LdapUtils.assertNotNullArg(parser, "URL parser cannot be null").parse(url));
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean isSchemeLdaps() {
        return LDAPS_SCHEME.equals(this.scheme);
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        if (this.port == -1) {
            int defaultPort;
            switch (this.scheme) {
                case "ldap": {
                    defaultPort = 389;
                    break;
                }
                case "ldaps": {
                    defaultPort = 636;
                    break;
                }
                case "ldapi": {
                    defaultPort = 0;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown scheme: " + this.scheme);
                }
            }
            return defaultPort;
        }
        return this.port;
    }

    public boolean isDefaultPort() {
        return this.port == -1;
    }

    public String getBaseDn() {
        return this.baseDn == null ? DEFAULT_BASE_DN : this.baseDn;
    }

    public Dn getParsedBaseDn() {
        return this.parsedBaseDn == null ? DEFAULT_PARSED_BASE_DN : this.parsedBaseDn;
    }

    public boolean isDefaultBaseDn() {
        return this.baseDn == null;
    }

    public String[] getAttributes() {
        return this.attributes == null ? DEFAULT_ATTRIBUTES : this.attributes;
    }

    public boolean isDefaultAttributes() {
        return this.attributes == null;
    }

    public SearchScope getScope() {
        return this.scope == null ? DEFAULT_SCOPE : this.scope;
    }

    public boolean isDefaultScope() {
        return this.scope == null;
    }

    public String getFilter() {
        return this.filter == null ? DEFAULT_FILTER : this.filter;
    }

    public Filter getParsedFilter() {
        return this.parsedFilter == null ? DEFAULT_PARSED_FILTER : this.parsedFilter;
    }

    public boolean isDefaultFilter() {
        return this.filter == null;
    }

    public String format() {
        return this.format(new MinimalUrlFormatter());
    }

    public String format(UrlFormatter formatter) {
        return formatter.format(this);
    }

    static void validateScheme(String scheme) {
        if (!(LDAP_SCHEME.equals(scheme) || LDAPS_SCHEME.equals(scheme) || LDAPI_SCHEME.equals(scheme))) {
            throw new IllegalArgumentException("Invalid LDAP URL scheme: " + scheme);
        }
    }

    static void validatePort(int port, boolean allowDefault) {
        if (port == -1 && allowDefault) {
            return;
        }
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port number: " + port);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Url) {
            Url v = (Url)o;
            return LdapUtils.areEqual(this.scheme, v.scheme) && LdapUtils.areEqual(this.hostname, v.hostname) && LdapUtils.areEqual(this.port, v.port) && LdapUtils.areEqual(this.baseDn, v.baseDn) && LdapUtils.areEqual(this.parsedBaseDn, v.parsedBaseDn) && LdapUtils.areEqual(this.attributes, v.attributes) && LdapUtils.areEqual((Object)this.scope, (Object)v.scope) && LdapUtils.areEqual(this.filter, v.filter) && LdapUtils.areEqual(this.parsedFilter, v.parsedFilter);
        }
        return false;
    }

    public int hashCode() {
        return LdapUtils.computeHashCode(11003, new Object[]{this.scheme, this.hostname, this.port, this.baseDn, this.parsedBaseDn, this.attributes, this.scope, this.filter, this.parsedFilter});
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::scheme=" + this.scheme + ", hostname=" + this.hostname + ", port=" + this.port + ", baseDn=" + this.baseDn + ", parsedBaseDn=" + String.valueOf(this.parsedBaseDn) + ", attributes=" + Arrays.toString(this.attributes) + ", scope=" + String.valueOf((Object)this.scope) + ", filter=" + this.filter + ", parsedFilter=" + String.valueOf(this.parsedFilter) + "]";
    }
}

