/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.url;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ldaptive.LdapUtils;
import org.ldaptive.SearchScope;
import org.ldaptive.url.Url;
import org.ldaptive.url.UrlParser;

public final class RegexUrlParser
implements UrlParser {
    private static final Pattern URL_PATTERN = Pattern.compile("([lL][dD][aA][pP][sSiI]?)://(\\[[0-9A-Fa-f:]+\\]|[^:/]+)?(?::(\\d+))?(?:/(?:([^?]+))?(?:\\?([^?]*))?(?:\\?([^?]*))?(?:\\?(.*))?)?");

    @Override
    public Url parse(String url) {
        Object[] attributes;
        String baseDn;
        int port;
        LdapUtils.assertNotNullArgOr(url, String::isEmpty, "LDAP URL cannot be null or empty");
        Matcher m = URL_PATTERN.matcher(url);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid LDAP URL: " + url);
        }
        String scheme = LdapUtils.toLowerCaseAscii(m.group(1));
        Url.validateScheme(scheme);
        String hostname = m.group(2);
        if (hostname != null) {
            if (hostname.startsWith("[") && hostname.endsWith("]")) {
                hostname = hostname.substring(1, hostname.length() - 1).trim();
            }
            if (hostname.isEmpty()) {
                throw new IllegalArgumentException("Invalid hostname: " + hostname);
            }
        }
        if (m.group(3) == null) {
            port = -1;
        } else {
            port = Integer.parseInt(m.group(3));
            Url.validatePort(port, false);
        }
        String string = baseDn = m.group(4) != null ? LdapUtils.percentDecode(m.group(4)) : null;
        Object[] objectArray = m.group(5) != null ? (!m.group(5).isEmpty() ? m.group(5).split(",") : null) : (attributes = null);
        if (attributes != null) {
            if (attributes.length == 0) {
                throw new IllegalArgumentException("Invalid attribute list: " + Arrays.toString(attributes));
            }
            for (int i = 0; i < attributes.length; ++i) {
                attributes[i] = LdapUtils.trimSpace((String)attributes[i]);
                if (!((String)attributes[i]).isEmpty()) continue;
                throw new IllegalArgumentException("Invalid attribute list: " + Arrays.toString(attributes));
            }
        }
        String scope = m.group(6);
        SearchScope searchScope = null;
        if (scope != null && !scope.isEmpty()) {
            if ("base".equalsIgnoreCase(scope)) {
                searchScope = SearchScope.OBJECT;
            } else if ("one".equalsIgnoreCase(scope)) {
                searchScope = SearchScope.ONELEVEL;
            } else if ("sub".equalsIgnoreCase(scope)) {
                searchScope = SearchScope.SUBTREE;
            } else {
                throw new IllegalArgumentException("Invalid scope: " + scope);
            }
        }
        String filter = m.group(7) != null ? (!m.group(7).isEmpty() ? LdapUtils.percentDecode(m.group(7)) : null) : null;
        return new Url(scheme, hostname, port, baseDn, (String[])attributes, searchScope, filter);
    }
}

