/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.url;

import java.util.ArrayList;
import org.ldaptive.LdapUtils;
import org.ldaptive.SearchScope;
import org.ldaptive.url.Url;
import org.ldaptive.url.UrlParser;

public final class DefaultUrlParser
implements UrlParser {
    @Override
    public Url parse(String url) {
        LdapUtils.assertNotNullArgOr(url, String::isEmpty, "LDAP URL cannot be null or empty");
        int currentPos = url.indexOf("://");
        if (currentPos < 0) {
            throw new IllegalArgumentException("LDAP URL must designate a scheme using '://'");
        }
        String scheme = LdapUtils.toLowerCaseAscii(url.substring(0, currentPos));
        Url.validateScheme(scheme);
        int nextPos = url.indexOf(47, currentPos + 3);
        Object[] hostAndPort = nextPos < 0 ? DefaultUrlParser.parseHostAndPort(url.substring(currentPos + 3)) : DefaultUrlParser.parseHostAndPort(url.substring(currentPos + 3, nextPos));
        String hostname = (String)hostAndPort[0];
        int port = (Integer)hostAndPort[1];
        String baseDn = null;
        if (nextPos > -1) {
            currentPos = nextPos;
            String string = baseDn = (nextPos = url.indexOf(63, currentPos)) < 0 ? LdapUtils.percentDecode(url.substring(currentPos + 1)) : LdapUtils.percentDecode(url.substring(currentPos + 1, nextPos));
            if (baseDn.isEmpty()) {
                baseDn = null;
            }
        }
        String[] attrs = null;
        if (nextPos > -1) {
            currentPos = nextPos;
            attrs = (nextPos = url.indexOf(63, currentPos + 1)) < 0 ? DefaultUrlParser.parseAttributes(url.substring(currentPos + 1)) : DefaultUrlParser.parseAttributes(url.substring(currentPos + 1, nextPos));
        }
        SearchScope scope = null;
        if (nextPos > -1) {
            currentPos = nextPos;
            scope = (nextPos = url.indexOf(63, currentPos + 1)) < 0 ? DefaultUrlParser.parseScope(url.substring(currentPos + 1)) : DefaultUrlParser.parseScope(url.substring(currentPos + 1, nextPos));
        }
        String filter = null;
        if (nextPos > -1 && (filter = LdapUtils.percentDecode(url.substring(nextPos + 1))).isEmpty()) {
            filter = null;
        }
        return new Url(scheme, hostname, port, baseDn, attrs, scope, filter);
    }

    private static Object[] parseHostAndPort(String hostAndPort) {
        int port;
        String hostname;
        LdapUtils.assertNotNullArg(hostAndPort, "Host and port cannot be null or empty");
        if (hostAndPort.isEmpty()) {
            return new Object[]{null, -1};
        }
        if (hostAndPort.indexOf(91) == 0) {
            int ipv6Port;
            int bracketPos = hostAndPort.indexOf(93);
            if (bracketPos < 0) {
                throw new IllegalArgumentException("IPv6 address is missing closing bracket: " + hostAndPort);
            }
            String ipv6Address = LdapUtils.trimSpace(hostAndPort.substring(1, bracketPos));
            if (ipv6Address.isEmpty()) {
                throw new IllegalArgumentException("IPv6 address is empty: " + hostAndPort);
            }
            if (bracketPos == hostAndPort.length() - 1) {
                ipv6Port = -1;
            } else {
                if (hostAndPort.charAt(bracketPos + 1) != ':') {
                    throw new IllegalArgumentException("IPv6 address invalid port designation: " + hostAndPort);
                }
                ipv6Port = Integer.parseInt(hostAndPort.substring(bracketPos + 2));
                Url.validatePort(ipv6Port, false);
            }
            return new Object[]{ipv6Address, ipv6Port};
        }
        int colonPos = hostAndPort.indexOf(58);
        if (colonPos < 0) {
            hostname = hostAndPort;
            port = -1;
        } else {
            hostname = hostAndPort.substring(0, colonPos);
            port = Integer.parseInt(hostAndPort.substring(colonPos + 1));
            Url.validatePort(port, false);
        }
        return new Object[]{hostname.isEmpty() ? null : hostname, port};
    }

    private static String[] parseAttributes(String attrs) {
        if (attrs == null || attrs.isEmpty()) {
            return null;
        }
        ArrayList<String> parsedAttrs = new ArrayList<String>();
        int pos = 0;
        int commaPos = 0;
        while (commaPos > -1) {
            String attrName;
            commaPos = attrs.indexOf(44, pos);
            String string = attrName = commaPos < 0 ? LdapUtils.trimSpace(attrs.substring(pos)) : LdapUtils.trimSpace(attrs.substring(pos, commaPos));
            if (commaPos < 0) {
                if (attrName.isEmpty()) {
                    if (parsedAttrs.isEmpty()) continue;
                    throw new IllegalArgumentException("Invalid attribute list: " + attrs);
                }
                parsedAttrs.add(attrName);
                continue;
            }
            if (attrName.isEmpty()) {
                throw new IllegalArgumentException("Invalid attribute list: " + attrs);
            }
            parsedAttrs.add(attrName);
            pos = commaPos + 1;
            if (pos < attrs.length()) continue;
            throw new IllegalArgumentException("Invalid attribute list: " + attrs);
        }
        return parsedAttrs.isEmpty() ? null : parsedAttrs.toArray(new String[0]);
    }

    private static SearchScope parseScope(String scope) {
        SearchScope ss;
        switch (LdapUtils.toLowerCaseAscii(scope)) {
            case "one": {
                ss = SearchScope.ONELEVEL;
                break;
            }
            case "sub": {
                ss = SearchScope.SUBTREE;
                break;
            }
            case "subordinates": {
                ss = SearchScope.SUBORDINATE;
                break;
            }
            case "base": 
            case "": {
                ss = SearchScope.OBJECT;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown search scope: " + scope);
            }
        }
        return ss;
    }
}

