/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ldaptive.AbstractFreezable;
import org.ldaptive.LdapUtils;
import org.ldaptive.schema.NamedElement;
import org.ldaptive.schema.SchemaElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SchemaElementRegistry<K, V extends SchemaElement<K>>
extends AbstractFreezable {
    private static final int HASH_CODE_SEED = 1187;
    private final Logger logger = LoggerFactory.getLogger(SchemaElementRegistry.class);
    private Map<K, V> keyRegistry = Collections.emptyMap();
    private Map<String, V> nameRegistry = Collections.emptyMap();
    private List<V> schemaElements = Collections.emptyList();

    SchemaElementRegistry() {
    }

    @Override
    public void freeze() {
        super.freeze();
        this.schemaElements.forEach(x$0 -> AbstractFreezable.freeze(x$0));
    }

    public Collection<V> getElements() {
        return Collections.unmodifiableList(this.schemaElements);
    }

    public V getElementByKey(K key) {
        if (key != null && this.keyRegistry.containsKey(key)) {
            return (V)((SchemaElement)this.keyRegistry.get(key));
        }
        return null;
    }

    public V getElementByName(String name) {
        String lowerCaseName;
        if (name != null && this.nameRegistry.containsKey(lowerCaseName = LdapUtils.toLowerCase(name))) {
            return (V)((SchemaElement)this.nameRegistry.get(lowerCaseName));
        }
        return null;
    }

    public void setElements(Collection<V> c) {
        this.assertMutable();
        this.parseElements(c);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SchemaElementRegistry) {
            SchemaElementRegistry v = (SchemaElementRegistry)o;
            return LdapUtils.areEqual(this.schemaElements, v.schemaElements) && LdapUtils.areEqual(this.keyRegistry, v.keyRegistry) && LdapUtils.areEqual(this.nameRegistry, v.nameRegistry);
        }
        return false;
    }

    public int hashCode() {
        return LdapUtils.computeHashCode(1187, this.schemaElements, this.keyRegistry, this.nameRegistry);
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::schemaElements=" + String.valueOf(this.schemaElements) + "]";
    }

    private void parseElements(Collection<V> c) {
        this.schemaElements = new ArrayList<V>(c.size());
        this.keyRegistry = new HashMap();
        this.nameRegistry = new HashMap<String, V>();
        for (SchemaElement v : c) {
            Object key = v.getElementKey();
            if (this.keyRegistry.containsKey(key)) {
                this.logger.warn("Duplicate key detected for {} and {}", (Object)v, this.keyRegistry.get(key));
            } else {
                this.keyRegistry.put(key, v);
            }
            if (v instanceof NamedElement) {
                for (String n : ((NamedElement)((Object)v)).getNames()) {
                    String lowerCaseName = LdapUtils.toLowerCase(n);
                    if (this.nameRegistry.containsKey(lowerCaseName)) {
                        this.logger.warn("Duplicate name detected for {} and {}", (Object)v, this.nameRegistry.get(lowerCaseName));
                        continue;
                    }
                    this.nameRegistry.put(lowerCaseName, v);
                }
            }
            this.schemaElements.add(v);
        }
    }
}

