/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.dn;

import java.util.function.Function;
import org.ldaptive.LdapUtils;

public final class NameValue {
    private static final int HASH_CODE_SEED = 5011;
    private final String attributeName;
    private final byte[] attributeValue;

    public NameValue(String name, String value) {
        this(name, LdapUtils.utf8Encode(value));
    }

    public NameValue(String name, byte[] value) {
        this.attributeName = LdapUtils.assertNotNullArg(name, "Name cannot be null");
        this.attributeValue = value;
    }

    public String getName() {
        return this.attributeName;
    }

    public byte[] getBinaryValue() {
        return this.attributeValue;
    }

    public String getStringValue() {
        return this.attributeValue != null ? LdapUtils.utf8Encode(this.attributeValue) : null;
    }

    public <T> T getValue(Function<byte[], T> func) {
        return func.apply(this.getBinaryValue());
    }

    public boolean hasName(String name) {
        return this.attributeName.equalsIgnoreCase(name);
    }

    public String format() {
        return this.attributeName + "=" + LdapUtils.utf8Encode(this.attributeValue);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NameValue) {
            NameValue v = (NameValue)o;
            return LdapUtils.areEqual(LdapUtils.toLowerCase(this.attributeName), LdapUtils.toLowerCase(v.attributeName)) && LdapUtils.areEqual(this.attributeValue, v.attributeValue);
        }
        return false;
    }

    public int hashCode() {
        return LdapUtils.computeHashCode(5011, LdapUtils.toLowerCase(this.attributeName), this.attributeValue);
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.hashCode() + "::name=" + this.attributeName + ", value=" + this.getStringValue();
    }
}

