/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ldaptive.AbstractFreezable;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.LdapUtils;
import org.ldaptive.ResultCode;
import org.ldaptive.auth.AuthenticationCriteria;
import org.ldaptive.auth.AuthenticationHandlerResponse;
import org.ldaptive.auth.EntryResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AggregateEntryResolver
extends AbstractFreezable
implements EntryResolver {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, EntryResolver> entryResolvers = new HashMap<String, EntryResolver>();

    public AggregateEntryResolver() {
    }

    public AggregateEntryResolver(Map<String, EntryResolver> resolvers) {
        this.setEntryResolvers(resolvers);
    }

    @Override
    public void freeze() {
        super.freeze();
        for (EntryResolver resolver : this.entryResolvers.values()) {
            AggregateEntryResolver.freeze(resolver);
        }
    }

    public Map<String, EntryResolver> getEntryResolvers() {
        return Collections.unmodifiableMap(this.entryResolvers);
    }

    public void setEntryResolvers(Map<String, EntryResolver> resolvers) {
        this.assertMutable();
        this.logger.trace("setting entryResolvers: {}", resolvers);
        this.entryResolvers.putAll(resolvers);
    }

    public void addEntryResolver(String label, EntryResolver resolver) {
        this.assertMutable();
        this.logger.trace("adding dnResolver: {}:{}", (Object)label, (Object)resolver);
        this.entryResolvers.put(label, resolver);
    }

    @Override
    public LdapEntry resolve(AuthenticationCriteria criteria, AuthenticationHandlerResponse response) throws LdapException {
        LdapUtils.assertNotNullArg(criteria, "Authentication criteria cannot be null");
        LdapUtils.assertNotNullArg(criteria.getDn(), "Authentication criteria DN cannot be null");
        String[] labeledDn = criteria.getDn().split(":", 2);
        EntryResolver er = this.entryResolvers.get(labeledDn[0]);
        if (er == null) {
            throw new LdapException(ResultCode.PARAM_ERROR, "Could not find entry resolver for label: " + labeledDn[0]);
        }
        return er.resolve(new AuthenticationCriteria(labeledDn[1], criteria.getAuthenticationRequest()), response);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final AggregateEntryResolver object = new AggregateEntryResolver();

        private Builder() {
        }

        public Builder freeze() {
            this.object.freeze();
            return this;
        }

        public Builder resolver(String label, EntryResolver resolver) {
            this.object.addEntryResolver(label, resolver);
            return this;
        }

        public AggregateEntryResolver build() {
            return this.object;
        }
    }
}

