/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth;

import java.time.ZonedDateTime;
import java.util.Arrays;
import javax.security.auth.login.LoginException;
import org.ldaptive.LdapUtils;

public class AccountState {
    private final Warning[] accountWarnings;
    private final Error[] accountErrors;

    public AccountState(Warning warning, Error error) {
        Error[] errorArray;
        Warning[] warningArray;
        if (warning != null) {
            Warning[] warningArray2 = new Warning[1];
            warningArray = warningArray2;
            warningArray2[0] = warning;
        } else {
            warningArray = this.accountWarnings = null;
        }
        if (error != null) {
            Error[] errorArray2 = new Error[1];
            errorArray = errorArray2;
            errorArray2[0] = error;
        } else {
            errorArray = null;
        }
        this.accountErrors = errorArray;
    }

    public AccountState(Warning[] warnings, Error[] errors) {
        this.accountWarnings = LdapUtils.copyArray(warnings);
        this.accountErrors = LdapUtils.copyArray(errors);
    }

    public AccountState(Warning ... warnings) {
        this.accountWarnings = LdapUtils.copyArray(warnings);
        this.accountErrors = null;
    }

    public AccountState(Error ... errors) {
        this.accountWarnings = null;
        this.accountErrors = LdapUtils.copyArray(errors);
    }

    public Warning[] getWarnings() {
        return LdapUtils.copyArray(this.accountWarnings);
    }

    public Warning getWarning() {
        return this.accountWarnings != null && this.accountWarnings.length > 0 ? this.accountWarnings[0] : null;
    }

    public Error[] getErrors() {
        return LdapUtils.copyArray(this.accountErrors);
    }

    public Error getError() {
        return this.accountErrors != null && this.accountErrors.length > 0 ? this.accountErrors[0] : null;
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::accountWarnings=" + Arrays.toString(this.accountWarnings) + ", accountErrors=" + Arrays.toString(this.accountErrors) + "]";
    }

    public static interface Warning {
        public ZonedDateTime getExpiration();

        public int getLoginsRemaining();
    }

    public static interface Error {
        public int getCode();

        public String getMessage();

        public void throwSecurityException() throws LoginException;
    }

    public static class DefaultWarning
    implements Warning {
        private final ZonedDateTime expiration;
        private final int loginsRemaining;

        public DefaultWarning(ZonedDateTime exp, int remaining) {
            this.expiration = exp;
            this.loginsRemaining = remaining;
        }

        @Override
        public ZonedDateTime getExpiration() {
            return this.expiration;
        }

        @Override
        public int getLoginsRemaining() {
            return this.loginsRemaining;
        }

        public String toString() {
            return "[" + this.getClass().getName() + "@" + this.hashCode() + "::expiration=" + String.valueOf(this.expiration) + ", loginsRemaining=" + this.loginsRemaining + "]";
        }
    }
}

