/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.ldaptive.AbstractMessage;
import org.ldaptive.AttributeModification;
import org.ldaptive.Freezable;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapUtils;
import org.ldaptive.asn1.AbstractParseHandler;
import org.ldaptive.asn1.DERBuffer;
import org.ldaptive.asn1.DERParser;
import org.ldaptive.asn1.DERPath;
import org.ldaptive.asn1.OctetStringType;
import org.ldaptive.dn.Dn;

public class LdapEntry
extends AbstractMessage
implements Freezable {
    public static final int PROTOCOL_OP = 4;
    private static final int HASH_CODE_SEED = 10303;
    private static final DERPath LDAP_DN_PATH = new DERPath("/SEQ/APP(4)/OCTSTR[0]");
    private static final DERPath ATTRIBUTES_PATH = new DERPath("/SEQ/APP(4)/SEQ/SEQ");
    private final Map<String, LdapAttribute> attributes = new LinkedHashMap<String, LdapAttribute>();
    private String ldapDn;
    private Dn parsedDn;
    private String normalizedDn;
    private volatile boolean immutable;

    public LdapEntry() {
    }

    public LdapEntry(DERBuffer buffer) {
        DERParser parser = new DERParser();
        parser.registerHandler(AbstractMessage.MessageIDHandler.PATH, new AbstractMessage.MessageIDHandler(this));
        parser.registerHandler(LDAP_DN_PATH, new LdapDnHandler(this));
        parser.registerHandler(ATTRIBUTES_PATH, new AttributesHandler(this));
        parser.registerHandler(AbstractMessage.ControlsHandler.PATH, new AbstractMessage.ControlsHandler(this));
        try {
            parser.parse(buffer);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing response", e);
        }
    }

    @Override
    public void freeze() {
        this.immutable = true;
        if (this.parsedDn != null) {
            this.parsedDn.freeze();
        }
        this.attributes.values().forEach(Freezable::freeze);
    }

    @Override
    public final boolean isFrozen() {
        return this.immutable;
    }

    @Override
    public final void assertMutable() {
        if (this.immutable) {
            throw new IllegalStateException("Cannot modify immutable object");
        }
    }

    public final String getDn() {
        return this.ldapDn;
    }

    public final Dn getParsedDn() {
        return this.parsedDn;
    }

    public final String getNormalizedDn() {
        return this.normalizedDn;
    }

    public final void setDn(String dn) {
        this.assertMutable();
        this.ldapDn = LdapUtils.assertNotNullArg(dn, "DN cannot be null");
        try {
            this.parsedDn = new Dn(this.ldapDn);
        }
        catch (Exception e) {
            this.parsedDn = null;
        }
        if (this.parsedDn != null) {
            this.normalizedDn = this.parsedDn.format();
        }
    }

    public boolean hasAttribute(String name) {
        if (name != null) {
            return this.attributes.containsKey(LdapUtils.toLowerCase(name));
        }
        return false;
    }

    public boolean hasAttributeValue(String name, byte[] value) {
        LdapAttribute attr = this.getAttribute(name);
        if (attr != null) {
            return attr.hasValue(value);
        }
        return false;
    }

    public boolean hasAttributeValue(String name, String value) {
        LdapAttribute attr = this.getAttribute(name);
        if (attr != null) {
            return attr.hasValue(value);
        }
        return false;
    }

    public Collection<LdapAttribute> getAttributes() {
        return this.immutable ? Collections.unmodifiableCollection(this.attributes.values()) : this.attributes.values();
    }

    public LdapAttribute getAttribute() {
        if (this.attributes.isEmpty()) {
            return null;
        }
        return this.attributes.values().iterator().next();
    }

    public LdapAttribute getAttribute(String name) {
        if (name != null) {
            return this.attributes.get(LdapUtils.toLowerCase(name));
        }
        return null;
    }

    public <T> T getAttributeValue(String name, Function<byte[], T> func) {
        LdapAttribute attr = this.getAttribute(name);
        if (attr != null) {
            return attr.getValue(func);
        }
        return null;
    }

    public <T> Collection<T> getAttributeValues(String name, Function<byte[], T> func) {
        LdapAttribute attr = this.getAttribute(name);
        if (attr != null) {
            return attr.getValues(func);
        }
        return Collections.emptyList();
    }

    public byte[] getAttributeBinaryValue(String name) {
        LdapAttribute attr = this.getAttribute(name);
        if (attr != null) {
            return attr.getBinaryValue();
        }
        return null;
    }

    public Collection<byte[]> getAttributeBinaryValues(String name) {
        LdapAttribute attr = this.getAttribute(name);
        if (attr != null) {
            return attr.getBinaryValues();
        }
        return Collections.emptyList();
    }

    public String getAttributeStringValue(String name) {
        LdapAttribute attr = this.getAttribute(name);
        if (attr != null) {
            return attr.getStringValue();
        }
        return null;
    }

    public Collection<String> getAttributeStringValues(String name) {
        LdapAttribute attr = this.getAttribute(name);
        if (attr != null) {
            return attr.getStringValues();
        }
        return Collections.emptyList();
    }

    public boolean processAttribute(String name, Consumer<LdapAttribute> func) {
        return this.mapAttribute(name, attr -> {
            func.accept((LdapAttribute)attr);
            return true;
        }, false);
    }

    public <T> T mapAttribute(String name, Function<LdapAttribute, T> func) {
        return this.mapAttribute(name, func, null);
    }

    public <T> T mapAttribute(String name, Function<LdapAttribute, T> func, T defaultValue) {
        LdapAttribute attr = this.getAttribute(name);
        if (attr != null) {
            return func.apply(attr);
        }
        return defaultValue;
    }

    public String[] getAttributeNames() {
        return (String[])this.attributes.values().stream().map(LdapAttribute::getName).toArray(String[]::new);
    }

    public void addAttributes(LdapAttribute ... attrs) {
        this.assertMutable();
        LdapUtils.assertNotContainsNullArgOr(attrs, Objects::isNull, "Attributes cannot be null or contain null");
        for (LdapAttribute a : attrs) {
            this.attributes.put(LdapUtils.toLowerCase(a.getName(), false), a);
        }
    }

    public void addAttributes(Collection<LdapAttribute> attrs) {
        this.assertMutable();
        LdapUtils.assertNotContainsNullArgOr(attrs, Objects::isNull, "Attributes cannot be null or contain null");
        attrs.forEach(a -> this.attributes.put(LdapUtils.toLowerCase(a.getName(), false), (LdapAttribute)a));
    }

    public void mergeAttributes(LdapAttribute ... attrs) {
        this.assertMutable();
        LdapUtils.assertNotContainsNullArgOr(attrs, Objects::isNull, "Attributes cannot be null or contain null");
        for (LdapAttribute a : attrs) {
            String lowerName = LdapUtils.toLowerCase(a.getName(), false);
            if (!this.attributes.containsKey(lowerName)) {
                this.attributes.put(lowerName, LdapAttribute.copy(a));
                continue;
            }
            this.attributes.get(lowerName).merge(a);
        }
    }

    public void mergeAttributes(Collection<LdapAttribute> attrs) {
        this.assertMutable();
        LdapUtils.assertNotContainsNullArgOr(attrs, Objects::isNull, "Attributes cannot be null or contain null");
        attrs.forEach(a -> {
            String lowerName = LdapUtils.toLowerCase(a.getName(), false);
            if (!this.attributes.containsKey(lowerName)) {
                this.attributes.put(lowerName, LdapAttribute.copy(a));
            } else {
                this.attributes.get(lowerName).merge((LdapAttribute)a);
            }
        });
    }

    public void removeAttribute(String name) {
        this.assertMutable();
        LdapUtils.assertNotNullArg(name, "Attribute name cannot be null");
        this.attributes.remove(LdapUtils.toLowerCase(name, false));
    }

    public void removeAttributes(LdapAttribute ... attrs) {
        this.assertMutable();
        LdapUtils.assertNotContainsNullArgOr(attrs, Objects::isNull, "Attributes cannot be null or contain null");
        for (LdapAttribute a : attrs) {
            this.attributes.remove(LdapUtils.toLowerCase(a.getName(), false));
        }
    }

    public void removeAttributes(Collection<LdapAttribute> attrs) {
        this.assertMutable();
        LdapUtils.assertNotContainsNullArgOr(attrs, Objects::isNull, "Attributes cannot be null or contain null");
        attrs.forEach(a -> this.attributes.remove(LdapUtils.toLowerCase(a.getName(), false)));
    }

    public final int size() {
        return this.attributes.size();
    }

    public final void clear() {
        this.assertMutable();
        this.attributes.clear();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LdapEntry && super.equals(o)) {
            LdapEntry v = (LdapEntry)o;
            return LdapUtils.areEqual(this.normalizedDn != null ? this.normalizedDn : this.ldapDn, this.normalizedDn != null ? v.normalizedDn : (v.normalizedDn != null ? v.normalizedDn : v.ldapDn)) && LdapUtils.areEqual(this.attributes, v.attributes);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return LdapUtils.computeHashCode(10303, this.getMessageID(), this.getControls(), this.normalizedDn != null ? this.normalizedDn : this.ldapDn, this.attributes);
    }

    @Override
    public String toString() {
        return super.toString() + ", dn=" + this.ldapDn + ", attributes=" + String.valueOf(this.attributes != null ? this.attributes.values() : null);
    }

    public static LdapEntry copy(LdapEntry entry) {
        LdapUtils.assertNotNullArg(entry, "Entry cannot be null");
        LdapEntry copy = new LdapEntry();
        copy.copyValues(entry);
        copy.ldapDn = entry.ldapDn;
        copy.parsedDn = entry.parsedDn != null ? Dn.copy(entry.parsedDn) : null;
        copy.normalizedDn = entry.normalizedDn;
        for (Map.Entry<String, LdapAttribute> e : entry.attributes.entrySet()) {
            copy.attributes.put(e.getKey(), LdapAttribute.copy(e.getValue()));
        }
        return copy;
    }

    public static LdapEntry sort(LdapEntry le) {
        LdapUtils.assertNotNullArg(le, "Entry cannot be null");
        LdapEntry sorted = new LdapEntry();
        sorted.copyValues(le);
        sorted.setDn(le.getDn());
        sorted.addAttributes(le.getAttributes().stream().map(LdapAttribute::sort).sorted(Comparator.comparing(o -> o.getName(false))).collect(Collectors.toCollection(LinkedHashSet::new)));
        if (le.isFrozen()) {
            sorted.freeze();
        }
        return sorted;
    }

    public static AttributeModification[] computeModifications(LdapEntry source, LdapEntry target) {
        return LdapEntry.computeModifications(source, target, true);
    }

    public static AttributeModification[] computeModifications(LdapEntry source, LdapEntry target, boolean useReplace) {
        LdapUtils.assertNotNullArg(source, "Source entry cannot be null");
        LdapUtils.assertNotNullArg(target, "Target entry cannot be null");
        ArrayList<AttributeModification> mods = new ArrayList<AttributeModification>();
        for (LdapAttribute sourceAttr : source.getAttributes()) {
            LdapAttribute targetAttr = target.getAttribute(sourceAttr.getName());
            if (targetAttr == null) {
                if (sourceAttr.size() > 0) {
                    mods.add(new AttributeModification(AttributeModification.Type.ADD, sourceAttr));
                    continue;
                }
                mods.add(new AttributeModification(AttributeModification.Type.REPLACE, sourceAttr));
                continue;
            }
            if (targetAttr.equals(sourceAttr)) continue;
            if (useReplace) {
                mods.add(new AttributeModification(AttributeModification.Type.REPLACE, sourceAttr));
                continue;
            }
            LdapAttribute toAdd = new LdapAttribute(sourceAttr.getName());
            sourceAttr.getBinaryValues().stream().filter(sv -> !targetAttr.hasValue((byte[])sv)).forEach(xva$0 -> toAdd.addBinaryValues(new byte[][]{xva$0}));
            if (toAdd.size() > 0) {
                mods.add(new AttributeModification(AttributeModification.Type.ADD, toAdd));
            }
            LdapAttribute toDelete = new LdapAttribute(sourceAttr.getName());
            targetAttr.getBinaryValues().stream().filter(tv -> !sourceAttr.hasValue((byte[])tv)).forEach(xva$0 -> toDelete.addBinaryValues(new byte[][]{xva$0}));
            if (toDelete.size() <= 0) continue;
            mods.add(new AttributeModification(AttributeModification.Type.DELETE, toDelete));
        }
        for (LdapAttribute targetAttr : target.getAttributes()) {
            LdapAttribute sourceAttr = source.getAttribute(targetAttr.getName());
            if (sourceAttr != null) continue;
            mods.add(new AttributeModification(AttributeModification.Type.DELETE, LdapAttribute.builder().name(targetAttr.getName()).build()));
        }
        return (AttributeModification[])mods.toArray(AttributeModification[]::new);
    }

    public static Builder builder() {
        return new Builder();
    }

    protected static class LdapDnHandler
    extends AbstractParseHandler<LdapEntry> {
        LdapDnHandler(LdapEntry response) {
            super(response);
        }

        @Override
        public void handle(DERParser parser, DERBuffer encoded) {
            ((LdapEntry)this.getObject()).setDn(OctetStringType.decode(encoded));
        }
    }

    protected static class AttributesHandler
    extends AbstractParseHandler<LdapEntry> {
        AttributesHandler(LdapEntry response) {
            super(response);
        }

        @Override
        public void handle(DERParser parser, DERBuffer encoded) {
            AttributeParser p = new AttributeParser();
            p.parse(encoded);
            if (p.getName().isEmpty()) {
                throw new IllegalArgumentException("Could not parse attribute");
            }
            if (p.getValues().isEmpty()) {
                ((LdapEntry)this.getObject()).addAttributes(LdapAttribute.builder().name(p.getName().get()).build());
            } else {
                ((LdapEntry)this.getObject()).addAttributes(LdapAttribute.builder().name(p.getName().get()).binaryValuesInternal((Collection<byte[]>)p.getValues().get()).build());
            }
        }
    }

    public static class Builder
    extends AbstractMessage.AbstractBuilder<Builder, LdapEntry> {
        protected Builder() {
            super(new LdapEntry());
        }

        @Override
        protected Builder self() {
            return this;
        }

        public Builder freeze() {
            ((LdapEntry)this.object).freeze();
            return this;
        }

        public Builder dn(String dn) {
            ((LdapEntry)this.object).setDn(dn);
            return this;
        }

        public Builder attributes(LdapAttribute ... attrs) {
            ((LdapEntry)this.object).addAttributes(attrs);
            return this;
        }

        public Builder attributes(Collection<LdapAttribute> attrs) {
            ((LdapEntry)this.object).addAttributes(attrs);
            return this;
        }
    }

    protected static class AttributeParser {
        private static final DERPath NAME_PATH = new DERPath("/OCTSTR");
        private static final DERPath VALUES_PATH = new DERPath("/SET/OCTSTR");
        private final DERParser parser = new DERParser();
        private final List<byte[]> values = new ArrayList<byte[]>();
        private String name;

        public AttributeParser() {
            this.parser.registerHandler(NAME_PATH, (p, e) -> {
                this.name = OctetStringType.decode(e);
            });
            this.parser.registerHandler(VALUES_PATH, (p, e) -> this.values.add(e.getRemainingBytes()));
        }

        public void parse(DERBuffer buffer) {
            this.parser.parse(buffer);
        }

        public Optional<String> getName() {
            return Optional.ofNullable(this.name);
        }

        public Optional<List<byte[]>> getValues() {
            return this.values.isEmpty() ? Optional.empty() : Optional.of(this.values);
        }
    }
}

