/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.util.Arrays;
import org.ldaptive.AbstractOperationFactory;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapUtils;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResponse;
import org.ldaptive.handler.LdapEntryHandler;
import org.ldaptive.handler.SearchReferenceHandler;
import org.ldaptive.handler.SearchResultHandler;

public abstract class AbstractSearchOperationFactory
extends AbstractOperationFactory<SearchRequest, SearchResponse> {
    private LdapEntryHandler[] entryHandlers;
    private SearchReferenceHandler[] referenceHandlers;
    private SearchResultHandler[] searchResultHandlers;

    @Override
    public void freeze() {
        super.freeze();
        AbstractSearchOperationFactory.freeze(this.entryHandlers);
        AbstractSearchOperationFactory.freeze(this.referenceHandlers);
        AbstractSearchOperationFactory.freeze(this.searchResultHandlers);
    }

    public LdapEntryHandler[] getEntryHandlers() {
        return LdapUtils.copyArray(this.entryHandlers);
    }

    public void setEntryHandlers(LdapEntryHandler ... handlers) {
        this.assertMutable();
        this.entryHandlers = LdapUtils.copyArray(handlers);
    }

    public SearchReferenceHandler[] getReferenceHandlers() {
        return LdapUtils.copyArray(this.referenceHandlers);
    }

    public void setReferenceHandlers(SearchReferenceHandler ... handlers) {
        this.assertMutable();
        this.referenceHandlers = LdapUtils.copyArray(handlers);
    }

    public SearchResultHandler[] getSearchResultHandlers() {
        return LdapUtils.copyArray(this.searchResultHandlers);
    }

    public void setSearchResultHandlers(SearchResultHandler ... handlers) {
        this.assertMutable();
        this.searchResultHandlers = LdapUtils.copyArray(handlers);
    }

    protected SearchOperation createSearchOperation() {
        return this.createSearchOperation(this.getConnectionFactory());
    }

    protected SearchOperation createSearchOperation(ConnectionFactory cf) {
        LdapUtils.assertNotNullArg(cf, "Connection factory cannot be null");
        SearchOperation op = new SearchOperation(cf);
        this.initializeOperation(op);
        if (this.entryHandlers != null) {
            op.setEntryHandlers(this.entryHandlers);
        }
        if (this.referenceHandlers != null) {
            op.setReferenceHandlers(this.referenceHandlers);
        }
        if (this.searchResultHandlers != null) {
            op.setSearchResultHandlers(this.searchResultHandlers);
        }
        return op;
    }

    @Override
    public String toString() {
        return super.toString() + ", " + (String)(this.entryHandlers != null ? "entryHandlers=" + Arrays.toString(this.entryHandlers) + ", " : "") + (String)(this.referenceHandlers != null ? "referenceHandlers=" + Arrays.toString(this.referenceHandlers) + ", " : "") + (String)(this.searchResultHandlers != null ? "searchResultHandlers=" + Arrays.toString(this.searchResultHandlers) : "");
    }
}

