/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.ldaptive.AbstractFreezable;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionValidator;
import org.ldaptive.LdapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnectionValidator
extends AbstractFreezable
implements ConnectionValidator {
    public static final Duration DEFAULT_VALIDATE_PERIOD = Duration.ofMinutes(30L);
    public static final Duration DEFAULT_VALIDATE_TIMEOUT = Duration.ofSeconds(5L);
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Duration validatePeriod;
    private Duration validateTimeout;
    private Consumer<Connection> onSuccess;
    private Consumer<Connection> onFailure;
    private boolean timeoutIsFailure = true;

    @Override
    public Duration getValidatePeriod() {
        return this.validatePeriod;
    }

    public void setValidatePeriod(Duration period) {
        this.assertMutable();
        LdapUtils.assertNotNullArgOr(period, p -> p.isNegative() || p.isZero(), "Period cannot be null, negative or zero");
        this.validatePeriod = period;
    }

    @Override
    public Duration getValidateTimeout() {
        return this.validateTimeout;
    }

    public void setValidateTimeout(Duration timeout) {
        this.assertMutable();
        LdapUtils.assertNotNullArgOr(timeout, Duration::isNegative, "Timeout cannot be null or negative");
        this.validateTimeout = timeout;
    }

    public Consumer<Connection> getOnSuccess() {
        return this.onSuccess;
    }

    public void setOnSuccess(Consumer<Connection> consumer) {
        this.assertMutable();
        this.onSuccess = consumer;
    }

    public Consumer<Connection> getOnFailure() {
        return this.onFailure;
    }

    public void setOnFailure(Consumer<Connection> consumer) {
        this.assertMutable();
        this.onFailure = consumer;
    }

    public boolean getTimeoutIsFailure() {
        return this.timeoutIsFailure;
    }

    public void setTimeoutIsFailure(boolean failure) {
        this.assertMutable();
        this.timeoutIsFailure = failure;
    }

    @Override
    public Boolean apply(Connection conn) {
        if (conn == null) {
            if (this.onFailure != null) {
                this.onFailure.accept(null);
            }
            return false;
        }
        Boolean result = this.applyAsync(conn).get();
        if (result.booleanValue() && this.onSuccess != null) {
            this.onSuccess.accept(conn);
        } else if (!result.booleanValue() && this.onFailure != null) {
            this.onFailure.accept(conn);
        }
        return result;
    }

    @Override
    public Supplier<Boolean> applyAsync(Connection conn) {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicBoolean result = new AtomicBoolean();
        this.applyAsync(conn, value -> {
            result.compareAndSet(false, (boolean)value);
            latch.countDown();
        });
        return () -> {
            try {
                if (Duration.ZERO.equals(this.getValidateTimeout())) {
                    latch.await();
                } else if (!latch.await(this.getValidateTimeout().toMillis(), TimeUnit.MILLISECONDS) && !this.timeoutIsFailure) {
                    this.logger.debug("Connection validator timeout ignored for {}", (Object)conn);
                    result.compareAndSet(false, true);
                }
            }
            catch (Exception e) {
                this.logger.debug("Validating {} threw unexpected exception", (Object)conn, (Object)e);
            }
            return result.get();
        };
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.hashCode() + "::validatePeriod=" + String.valueOf(this.validatePeriod) + ", validateTimeout=" + String.valueOf(this.validateTimeout) + ", onSuccess=" + String.valueOf(this.onSuccess) + ", onFailure=" + String.valueOf(this.onFailure) + ", timeoutIsFailure=" + this.timeoutIsFailure;
    }

    protected static abstract class AbstractBuilder<B, T extends AbstractConnectionValidator> {
        protected final T object;

        protected AbstractBuilder(T t) {
            this.object = t;
        }

        protected abstract B self();

        public B freeze() {
            ((AbstractFreezable)this.object).freeze();
            return this.self();
        }

        public B period(Duration period) {
            ((AbstractConnectionValidator)this.object).setValidatePeriod(period);
            return this.self();
        }

        public B timeout(Duration timeout) {
            ((AbstractConnectionValidator)this.object).setValidateTimeout(timeout);
            return this.self();
        }

        public B onSuccess(Consumer<Connection> consumer) {
            ((AbstractConnectionValidator)this.object).setOnSuccess(consumer);
            return this.self();
        }

        public B onFailure(Consumer<Connection> consumer) {
            ((AbstractConnectionValidator)this.object).setOnFailure(consumer);
            return this.self();
        }

        public B timeoutIsFailure(boolean failure) {
            ((AbstractConnectionValidator)this.object).setTimeoutIsFailure(failure);
            return this.self();
        }

        public T build() {
            return this.object;
        }
    }
}

